#version 150

// Import Minecraft's fog utility functions
#moj_import <fog.glsl>

// ======= Uniforms (Global Inputs) =======
uniform sampler2D Sampler0;      // Base texture of the entity
uniform vec4 ColorModulator;     // Color tint applied to all fragments
uniform float FogStart;          // Start distance of fog effect
uniform float FogEnd;            // End distance of fog effect
uniform vec4 FogColor;           // Fog color

// ======= Inputs from Vertex Shader =======
in float vertexDistance;         // Distance from camera (used for fog)
in vec4 vertexColor;             // Per-vertex color
in vec4 lightMapColor;           // Combined lightmap brightness
in vec4 overlayColor;            // Overlay color (e.g., damage flash)
in vec2 texCoord0;               // Base texture coordinates
in vec4 normal;                  // Vertex normal (unused here, but passed through)

// ======= Output to Framebuffer =======
out vec4 fragColor;

void main() {
    // Sample texture color and apply vertex + global color modifiers
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;

    // Blend overlay (damage tint, enchant glow, etc.)
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);

    // Apply lightmap brightness
    color *= lightMapColor;

    // Discard nearly transparent pixels
    if (color.a < 0.1) {
        discard;
    }

    // Apply linear fog and output final color
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
