#version 150

// Import Minecraft lighting and fog functions
#moj_import <light.glsl>
#moj_import <fog.glsl>

// ===== Vertex Attributes =====
in vec3 Position;   // Vertex position
in vec4 Color;      // Vertex color
in vec2 UV0;        // Texture coordinates
in vec3 Normal;     // Vertex normal

// ===== Global Uniforms (auto-provided by Minecraft) =====
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform int FogShape;
uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;
uniform vec4 ColorModulator;

// ===== Outputs to Fragment Shader =====
out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

void main() {
    // Transform vertex position to clip space
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    // Compute distance for fog
    vec3 viewPos = (ModelViewMat * vec4(Position, 1.0)).xyz;
	vertexDistance = length(viewPos);

    // Compute lighting using vanilla global light directions
    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);

    // Pass base texture coordinates
    texCoord0 = UV0;
}
