#version 150

// Import Minecraft fog utilities
#moj_import <fog.glsl>

// ===== Global Uniforms =====
uniform sampler2D Sampler0;  // Base texture
uniform vec4 ColorModulator; // Global color multiplier
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

// ===== Inputs from Vertex Shader =====
in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

// ===== Output =====
out vec4 fragColor;

void main() {
    // Base texture color * lighting * global color
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;

    // Discard transparent fragments
    if (color.a < 0.1) discard;

    // Apply fog
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
