#version 150

// Import fog functions
#moj_import <fog.glsl>

// ======= Uniforms =======
uniform sampler2D Sampler0;      // Base block texture
uniform vec4 ColorModulator;     // Global color modifier
uniform float FogStart;          // Fog start distance
uniform float FogEnd;            // Fog end distance
uniform vec4 FogColor;           // Fog color

// ======= Inputs =======
in float vertexDistance;         // Distance from camera (for fog)
in vec4 vertexColor;             // Vertex color
in vec2 texCoord0;               // Texture coordinates
in vec4 normal;                  // Vertex normal (unused)

// ======= Output =======
out vec4 fragColor;

void main() {
    // Combine base texture and vertex color
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;

    // Discard transparent pixels
    if (color.a < 0.1) {
        discard;
    }

    // Apply fog based on distance
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
