#version 150

// Import Minecraft fog library
#moj_import <minecraft:fog.glsl>

// Uniform variables
uniform sampler2D Sampler0; // Main texture sampler

uniform vec4 ColorModulator; // Color modulation from game
uniform float FogStart;      // Fog start distance
uniform float FogEnd;        // Fog end distance  
uniform vec4 FogColor;       // Fog color

// Input variables from vertex shader
in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

// Output fragment color
out vec4 fragColor;

void main() {
    // Sample main texture
    vec4 color = texture(Sampler0, texCoord0);

    // Alpha cutoff for transparent pixels
    #ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) discard;
    #endif

    // Apply lighting based on texture alpha channel
    #ifndef EMISSIVE
    int alpha = int(round(color.a * 255));
    switch (alpha) {
        case 252: // Fullbright - no lighting applied
            break;
        case 253: // Partial lighting - only directional light
            color *= lightColor;
            break;
        default:  // Full lighting - directional + ambient
            color *= lightColor * lightMapColor;
            break;
    }
    #endif

    // Apply vertex color and color modulation
    color *= vertexColor * ColorModulator;

    // Apply overlay color (like team colors)
    #ifndef NO_OVERLAY
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    #endif

    // Apply fog based on distance
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}