#version 150

// Import Minecraft-specific GLSL libraries for fog and dynamic transformations
#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

// Uniform sampler for the main texture
uniform sampler2D Sampler0;

// Input variables from vertex shader
in float sphericalVertexDistance;    // Distance for spherical fog calculation
in float cylindricalVertexDistance;  // Distance for cylindrical fog calculation
in vec4 vertexColor;                 // Color from vertex attributes
in vec4 lightColor;                  // Computed lighting color
in vec4 overlayColor;                // Overlay texture color (team colors, etc.)
in vec2 texCoord0;                   // Texture coordinates

// Output fragment color
out vec4 fragColor;

void main() {
    // Sample the main texture
    vec4 color = texture(Sampler0, texCoord0);
    
    // Apply lighting unless this is an emissive material
    #ifndef EMISSIVE
    // Check if this pixel should receive lighting (alpha value 252 = fullbright/no lighting)
    if (int(round(color.a * 255)) != 252) {
        // Apply directional and ambient lighting
        color *= lightColor;
    }
    #endif
    
    // Apply vertex color and global color modulation
    color *= vertexColor * ColorModulator;
    
    // Alpha cutoff - discard transparent pixels
    // This prevents rendering of nearly transparent fragments
    if (color.a < 0.1) {
        discard;  // Completely skip this fragment
    }
    
    // Apply overlay color (like team colors) unless disabled
    #ifndef NO_OVERLAY
    // Blend between overlay color and base color based on overlay alpha
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    #endif
    
    // Apply advanced fog calculation with multiple distance types and fog ranges
    // Uses both spherical and cylindrical distances with environmental and render distance fog bounds
    fragColor = apply_fog(
        color,                           // Base color to apply fog to
        sphericalVertexDistance,         // Distance calculated spherically from camera
        cylindricalVertexDistance,       // Distance calculated cylindrically from camera
        FogEnvironmentalStart,           // Start distance for environmental fog (sky, water, etc.)
        FogEnvironmentalEnd,             // End distance for environmental fog
        FogRenderDistanceStart,          // Start distance for render distance fog
        FogRenderDistanceEnd,            // End distance for render distance fog
        FogColor                         // Color of the fog
    );
}