#version 150

// Import Minecraft lighting and fog functions
#moj_import <light.glsl>
#moj_import <fog.glsl>

// ======= Vertex Attributes =======
in vec3 Position;   // Vertex position in model space
in vec4 Color;      // Vertex color
in vec2 UV0;        // Texture coordinates (base texture)
in ivec2 UV1;       // Overlay texture coordinates
in ivec2 UV2;       // Lightmap texture coordinates
in vec3 Normal;     // Vertex normal in model space

// ======= Uniforms =======
uniform sampler2D Sampler1;      // Overlay texture
uniform sampler2D Sampler2;      // Lightmap texture

uniform mat4 ModelViewMat;       // Model-View matrix
uniform mat4 ProjMat;            // Projection matrix
uniform mat3 IViewRotMat;        // Inverse view rotation matrix
uniform int FogShape;            // Fog mode (sphere, cylinder, etc.)

uniform vec3 Light0_Direction;   // Direction of first light source
uniform vec3 Light1_Direction;   // Direction of second light source

// ======= Outputs to Fragment Shader =======
out float vertexDistance;        // Distance to camera for fog
out vec4 vertexColor;            // Final per-vertex color
out vec4 lightMapColor;          // Lightmap intensity
out vec4 overlayColor;           // Overlay color (e.g., damage flash)
out vec2 texCoord0;              // Base texture coordinates
out vec4 normal;                 // Transformed normal vector

void main() {
    // Transform vertex position to clip space
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    // Compute distance from camera for fog
    vertexDistance = fog_distance(ModelViewMat, IViewRotMat * Position, FogShape);

    // Calculate lighting based on light directions and vertex normal
    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);

    // Sample lightmap and overlay colors from textures
    lightMapColor = texelFetch(Sampler2, UV2 / 16, 0);
    overlayColor = texelFetch(Sampler1, UV1, 0);

    // Pass through base texture coordinates
    texCoord0 = UV0;

    // Transform normal to clip space (used by fog or custom effects)
    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
}
