/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ai.max_elephant;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.TravelParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.ten_shadows.MaxElephantEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Water
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    public static final double RANGE = 20.0;
    private static final float SCALE = 2.0f;
    private static final float DAMAGE = 2.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (owner.m_20160_()) {
            return JJKAbilities.isChanneling((LivingEntity)owner, this);
        }
        return target != null && !target.m_21224_() && (double)owner.m_20270_((Entity)target) <= 20.0 && RotationUtil.hasLineOfSight(Water.calculateSpawnPos((LivingEntity)owner), (Entity)owner, (Entity)target);
    }

    private static Vec3 calculateSpawnPos(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        return new Vec3(owner.m_20185_(), owner.m_20188_() - 0.5, owner.m_20189_()).m_82549_(look);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return owner instanceof MaxElephantEntity;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    private Vec3 getCollision(LivingEntity owner, Vec3 from, Vec3 to) {
        double collidePosZ;
        double collidePosY;
        double collidePosX;
        BlockHitResult result = owner.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner));
        if (result.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = result.m_82450_();
            collidePosX = pos.f_82479_;
            collidePosY = pos.f_82480_;
            collidePosZ = pos.f_82481_;
        } else {
            collidePosX = to.f_82479_;
            collidePosY = to.f_82480_;
            collidePosZ = to.f_82481_;
        }
        return new Vec3(collidePosX, collidePosY, collidePosZ);
    }

    public List<Entity> checkCollisions(LivingEntity owner, Vec3 from, Vec3 to, Vec3 collision) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        AABB bounds = new AABB(Math.min(from.f_82479_, collision.f_82479_), Math.min(from.f_82480_, collision.f_82480_), Math.min(from.f_82481_, collision.f_82481_), Math.max(from.f_82479_, collision.f_82479_), Math.max(from.f_82480_, collision.f_82480_), Math.max(from.f_82481_, collision.f_82481_)).m_82400_(2.0);
        for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, bounds)) {
            float pad = entity.m_6143_() + 0.5f;
            AABB padded = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = padded.m_82371_(from, to);
            if (padded.m_82390_(from)) {
                entities.add(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 spawn = Water.calculateSpawnPos(owner);
        float yaw = (float)((double)(RotationUtil.getTargetAdjustedYRot(spawn, (Entity)owner) + 90.0f) * Math.PI / 180.0);
        float pitch = (float)((double)(-RotationUtil.getTargetAdjustedXRot(spawn, (Entity)owner)) * Math.PI / 180.0);
        double endPosX = spawn.f_82479_ + 20.0 * Math.cos(yaw) * Math.cos(pitch);
        double endPosY = spawn.f_82480_ + 20.0 * Math.sin(pitch);
        double endPosZ = spawn.f_82481_ + 20.0 * Math.sin(yaw) * Math.cos(pitch);
        Vec3 end = new Vec3(endPosX, endPosY, endPosZ);
        Vec3 collision = this.getCollision(owner, spawn, end);
        TravelParticle.TravelParticleOptions particle = new TravelParticle.TravelParticleOptions(collision.m_252839_(), Vec3.m_82501_((int)MapColor.f_283864_.f_283871_).m_252839_(), 2.0f * HelperMethods.RANDOM.m_188501_() * 0.5f, 0.5f, false, (int)spawn.m_82554_(collision) / 2);
        for (int i = 0; i < 32; ++i) {
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)particle, spawn.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.0, spawn.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.0, spawn.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.0, 0, 0.0, 0.0, 0.0, 1.0);
        }
        List<Entity> entities = this.checkCollisions(owner, spawn, end, collision);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                LivingEntity living;
                ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (entity instanceof LivingEntity && !owner.m_6779_(living = (LivingEntity)entity) || entity == owner && !cap.hasSelfHit()) continue;
            }
            if (!entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 2.0f * this.getPower(owner))) continue;
            entity.m_20256_(spawn.m_82546_(entity.m_20182_()).m_82541_().m_82548_());
            entity.f_19864_ = true;
        }
        double radius = 4.0;
        AABB bounds = new AABB(collision.f_82479_ - radius, collision.f_82480_ - radius, collision.f_82481_ - radius, collision.f_82479_ + radius, collision.f_82480_ + radius, collision.f_82481_ + radius);
        double centerX = bounds.m_82399_().f_82479_;
        double centerY = bounds.m_82399_().f_82480_;
        double centerZ = bounds.m_82399_().f_82481_;
        int x = (int)bounds.f_82288_;
        while ((double)x <= bounds.f_82291_) {
            int y = (int)bounds.f_82289_;
            while ((double)y <= bounds.f_82292_) {
                int z = (int)bounds.f_82290_;
                while ((double)z <= bounds.f_82293_) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = owner.m_9236_().m_8055_(pos);
                    double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                    if (!(distance > radius) && !state.m_60804_((BlockGetter)owner.m_9236_(), pos)) {
                        owner.m_9236_().m_46961_(pos, false);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 5.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getDuration() {
        return 60;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.WATER;
    }
}

