/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.base;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsMode;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public abstract class Summon<T extends Entity>
extends Ability
implements Ability.IToggled {
    private final Class<T> clazz;

    public Summon(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final Class<T> getClazz() {
        return this.clazz;
    }

    public abstract List<EntityType<?>> getTypes();

    protected boolean canTame() {
        return false;
    }

    public boolean canDie() {
        return false;
    }

    public boolean display() {
        return true;
    }

    public boolean isTotality() {
        return false;
    }

    public List<EntityType<?>> getFusions() {
        return List.of();
    }

    public abstract boolean isTenShadows();

    public boolean isSpecificFusion() {
        return true;
    }

    protected boolean shouldRemove() {
        return true;
    }

    protected boolean isBottomlessWell() {
        return false;
    }

    public boolean isTamed(LivingEntity owner) {
        if (!this.canTame()) {
            return true;
        }
        ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        for (EntityType<?> type : this.getTypes()) {
            if (!cap.hasTamed(owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_), type)) continue;
            return true;
        }
        return false;
    }

    public boolean isDead(LivingEntity owner) {
        for (EntityType<?> type : this.getTypes()) {
            if (!this.isDead(owner, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        if (!super.isValid(owner)) {
            return false;
        }
        if (!JJKAbilities.hasToggled(owner, this) && this.isTenShadows()) {
            ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.getMode() != TenShadowsMode.SUMMON) {
                return false;
            }
            for (Ability ability : JJKAbilities.getToggled(owner)) {
                if (!(ability instanceof Summon)) continue;
                Summon summon = (Summon)ability;
                for (EntityType<?> type : this.getTypes()) {
                    if (summon.getTypes().contains(type)) {
                        return false;
                    }
                    if (!summon.getFusions().contains(type)) continue;
                    return false;
                }
                for (EntityType<?> fusion : this.getFusions()) {
                    if (!JJKAbilities.hasTamed(owner, fusion)) {
                        return false;
                    }
                    if (summon.getTypes().contains(fusion)) {
                        return false;
                    }
                    if (!summon.getFusions().contains(fusion)) continue;
                    return false;
                }
            }
            List<EntityType<?>> fusions = this.getFusions();
            int dead = 0;
            for (int i = 0; i < fusions.size(); ++i) {
                if (this.isBottomlessWell()) {
                    if (!JJKAbilities.isDead(owner, fusions.get(i)) && JJKAbilities.hasTamed(owner, fusions.get(i))) continue;
                    return false;
                }
                if (this.isSpecificFusion()) {
                    if (i == 0 != JJKAbilities.isDead(owner, fusions.get(i))) continue;
                    return false;
                }
                if (!JJKAbilities.isDead(owner, fusions.get(i))) continue;
                ++dead;
            }
            if (!(this.isSpecificFusion() || dead != 0 && dead != fusions.size())) {
                return false;
            }
        }
        return !this.isDead(owner);
    }

    protected boolean isDead(LivingEntity owner, EntityType<?> type) {
        if (!this.canDie()) {
            return false;
        }
        ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.isDead(owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_), type);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        if (this.getActivationType(owner) == Ability.ActivationType.INSTANT) {
            this.spawn(owner, false);
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        ISorcererData cap = owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
        if (cap == null) {
            return Ability.Status.FAILURE;
        }
        if ((this.isTenShadows() || this.getActivationType(owner) == Ability.ActivationType.TOGGLED) && cap.hasSummonOfClass(this.clazz)) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        if (!owner.m_9236_().f_46443_) {
            ISorcererData cap = owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
            if (cap == null) {
                return Ability.Status.FAILURE;
            }
            if (!cap.hasSummonOfClass(this.clazz)) {
                return Ability.Status.FAILURE;
            }
        }
        return super.isStillUsable(owner);
    }

    protected abstract T summon(LivingEntity var1);

    public void spawn(LivingEntity owner, boolean clone) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        T summon = this.summon(owner);
        if (summon instanceof TenShadowsSummon) {
            ((TenShadowsSummon)summon).setClone(clone);
        }
        owner.m_9236_().m_7967_(summon);
        if (!owner.m_20096_() && owner.m_20202_() == null && this.isTamed(owner) && this.canFly()) {
            owner.m_20329_(summon);
        }
        cap.addSummon((Entity)summon);
    }

    @Override
    public void onEnabled(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        this.spawn(owner, false);
    }

    public boolean canFly() {
        return false;
    }

    @Override
    public void onDisabled(LivingEntity owner) {
        if (!owner.m_9236_().f_46443_) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (this.shouldRemove()) {
                cap.unsummonByClass(this.clazz);
            } else {
                cap.removeSummonByClass(this.clazz);
            }
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }
    }

    @Override
    public float getRealCost(LivingEntity owner) {
        return this.isTenShadows() && this.isTamed(owner) && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.CHIMERA_SHADOW_GARDEN.get()) ? 0.0f : super.getRealCost(owner);
    }
}

