/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.curse.AbsorbedPlayerEntity;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ReleaseCurse
extends Ability {
    private static final double RANGE = 32.0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private Entity getTarget(LivingEntity owner) {
        HitResult hitResult = RotationUtil.getLookAtHit((Entity)owner, 32.0);
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult hit = (EntityHitResult)hitResult;
            return hit.m_82443_();
        }
        return null;
    }

    private static void makePoofParticles(Entity entity) {
        for (int i = 0; i < 20; ++i) {
            double d0 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d1 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d2 = HelperMethods.RANDOM.m_188583_() * 0.02;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0, d0, d1, d2, 1.0);
        }
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        CursedSpirit curse;
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Entity entity = this.getTarget(owner);
        if (entity instanceof CursedSpirit && (curse = (CursedSpirit)entity).m_21824_() && curse.m_269323_() == owner) {
            owner.m_6674_(InteractionHand.MAIN_HAND);
            ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ownerCap.removeSummon((Entity)curse);
            ISorcererData curseCap = (ISorcererData)curse.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (curse instanceof AbsorbedPlayerEntity) {
                AbsorbedPlayerEntity absorbed = (AbsorbedPlayerEntity)curse;
                ownerCap.addCurse(new AbsorbedCurse(curse.m_7755_(), curse.m_6095_(), curseCap.serializeNBT(), absorbed.getPlayer()));
            } else {
                ownerCap.addCurse(new AbsorbedCurse(curse.m_7755_(), curse.m_6095_(), curseCap.serializeNBT()));
            }
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(ownerCap.serializeNBT()), player);
            }
            if (!owner.m_9236_().f_46443_) {
                ReleaseCurse.makePoofParticles((Entity)curse);
            }
            curse.m_146870_();
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        CursedSpirit curse;
        Entity entity = this.getTarget(owner);
        if (!(entity instanceof CursedSpirit) || !(curse = (CursedSpirit)entity).m_21824_() || curse.m_269323_() != owner) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

