/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.WormCurseEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class WormCurseGrab
extends Ability {
    public static final double RANGE = 60.0;
    public LivingEntity enemy = null;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        if (!super.isValid(owner)) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.hasCurse((EntityType)JJKEntities.WORM_CURSE.get());
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 60.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        Entity entity;
        LivingEntity target = this.enemy;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        AbsorbedCurse curse = cap.getCurse((EntityType)JJKEntities.WORM_CURSE.get());
        if (curse == null || curse.equals(null) || !((entity = JJKAbilities.summonCurse(owner, curse, false)) instanceof WormCurseEntity)) {
            return;
        }
        WormCurseEntity worm = (WormCurseEntity)entity;
        worm.grab(target);
        this.enemy = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        AbsorbedCurse curse = cap.getCurse((EntityType)JJKEntities.WORM_CURSE.get());
        return curse == null ? 0.0f : JJKAbilities.getCurseCost(curse);
    }

    @Override
    protected int getCooldown() {
        return 200;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

