/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_flames;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.LavaRockProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;

public class CoffinOfTheIronMountain
extends DomainExpansion
implements DomainExpansion.IClosedDomain {
    private static final float DAMAGE = 10.0f;

    @Override
    public List<Block> getBlocks() {
        return List.of((Block)JJKBlocks.COFFIN_OF_THE_IRON_MOUNTAIN_ONE.get(), (Block)JJKBlocks.COFFIN_OF_THE_IRON_MOUNTAIN_TWO.get(), (Block)JJKBlocks.COFFIN_OF_THE_IRON_MOUNTAIN_THREE.get());
    }

    @Override
    @Nullable
    public ParticleOptions getEnvironmentParticle() {
        return ParticleTypes.f_123755_;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        boolean enemyDomain = false;
        DomainExpansionEntity selfDomain = null;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                selfDomain = domain;
                continue;
            }
            if (domain.getOwner() == owner) continue;
            enemyDomain = true;
        }
        if (enemyDomain) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasToggled(this)) {
                return true;
            }
            if (cap.hasToggled(this)) {
                return false;
            }
        } else if (selfDomain != null && !enemyDomain) {
            if (target != null) {
                return (double)selfDomain.m_20270_((Entity)target) >= 60.0;
            }
            if (target == null) {
                return HelperMethods.RANDOM.m_188503_(15) == 0;
            }
        }
        return target != null && (double)owner.m_20270_((Entity)target) <= 25.0 && owner.m_21223_() / owner.m_21233_() < 0.9f && HelperMethods.RANDOM.m_188503_(4) == 0;
    }

    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        super.onHitEntity(domain, owner, entity, instant);
        if (instant || owner.m_9236_().m_46467_() % 20L == 0L) {
            if (entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack(domain, owner, this), 10.0f * this.getPower(owner) * CoffinOfTheIronMountain.getStrength(owner, false))) {
                entity.m_20254_(15);
            }
            if (owner.m_142582_((Entity)entity)) {
                LavaRockProjectile rock = new LavaRockProjectile(owner, this.getPower(owner) * CoffinOfTheIronMountain.getStrength(owner, false), entity);
                rock.setDomain(true);
                owner.m_9236_().m_7967_((Entity)rock);
            }
        }
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        int radius = Math.round(this.getRadius(owner));
        ClosedDomainExpansionEntity domain = new ClosedDomainExpansionEntity(owner, this, radius);
        owner.m_9236_().m_7967_((Entity)domain);
        return domain;
    }
}

