/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_tides;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.EelShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.PiranhaShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.SharkShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.FishShikigamiProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class DeathSwarm
extends Ability
implements Ability.IDomainAttack {
    public static final double RANGE = 50.0;
    public LivingEntity enemy = null;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(5) == 0 && target != null && !target.m_21224_() && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 50.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    private void perform(LivingEntity owner, LivingEntity target, @Nullable DomainExpansionEntity domain) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (int i = 0; i < 10; ++i) {
            float xOffset = (HelperMethods.RANDOM.m_188501_() - 0.5f) * 5.0f;
            float yOffset = owner.m_20206_() + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 5.0f;
            float power = domain == null ? this.getPower(owner) : this.getPower(owner) * 0.75f * DomainExpansion.getStrength(owner, false);
            FishShikigamiProjectile[] projectiles = new FishShikigamiProjectile[]{new EelShikigamiProjectile(owner, power, target, xOffset, yOffset), new SharkShikigamiProjectile(owner, power, target, xOffset, yOffset), new PiranhaShikigamiProjectile(owner, power, target, xOffset, yOffset)};
            int delay = i * 3;
            cap.delayTickEvent(() -> {
                if (target != null && target.m_6084_() && !target.m_213877_()) {
                    FishShikigamiProjectile projectile = projectiles[HelperMethods.RANDOM.m_188503_(projectiles.length)];
                    projectile.setDomain(domain != null);
                    owner.m_9236_().m_7967_((Entity)projectile);
                }
            }, delay);
        }
    }

    @Override
    public void performEntity(LivingEntity owner, LivingEntity target, DomainExpansionEntity domain) {
        this.perform(owner, target, domain);
    }

    @Override
    public void run(LivingEntity owner) {
        LivingEntity newEnemy = this.enemy;
        this.perform(owner, newEnemy, null);
        this.enemy = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 250.0f;
    }

    @Override
    public int getCooldown() {
        return 500;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

