/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.ability.idle_transfiguration.IdleTransfiguration;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.SelfEmbodimentOfPerfectionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class SelfEmbodimentOfPerfection
extends DomainExpansion
implements DomainExpansion.IClosedDomain {
    @Override
    @Nullable
    public ParticleOptions getEnvironmentParticle() {
        return ParticleTypes.f_123790_;
    }

    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        super.onHitEntity(domain, owner, entity, instant);
        if (IdleTransfiguration.checkSukuna(owner, entity)) {
            return;
        }
        float attackerStrength = IdleTransfiguration.calculateStrength(owner);
        float victimStrength = IdleTransfiguration.calculateStrength(entity);
        int required = Math.round(victimStrength / (float)Math.round(attackerStrength * 2.0f / 7.0f) * 2.0f);
        MobEffectInstance instance = new MobEffectInstance((MobEffect)JJKEffects.TRANSFIGURED_SOUL.get(), Math.round(400.0f * SelfEmbodimentOfPerfection.getStrength(owner, instant)), required, false, true, true);
        entity.m_7292_(instance);
        if (!owner.m_9236_().f_46443_) {
            PacketDistributor.TRACKING_ENTITY.with(() -> entity).send((Packet)new ClientboundUpdateMobEffectPacket(entity.m_19879_(), instance));
        }
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        boolean enemyDomain = false;
        DomainExpansionEntity selfDomain = null;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                selfDomain = domain;
                continue;
            }
            if (domain.getOwner() == owner) continue;
            enemyDomain = true;
        }
        if (enemyDomain) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasToggled(this)) {
                return true;
            }
            if (cap.hasToggled(this)) {
                return false;
            }
        } else if (selfDomain != null && !enemyDomain) {
            if (target != null) {
                return (double)selfDomain.m_20270_((Entity)target) >= 96.0;
            }
            if (target == null) {
                return HelperMethods.RANDOM.m_188503_(15) == 0;
            }
        }
        return target != null && (double)owner.m_20270_((Entity)target) <= 25.0 && owner.m_21223_() / owner.m_21233_() < 0.9f && HelperMethods.RANDOM.m_188503_(4) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        int radius = Math.round(this.getRadius(owner));
        ClosedDomainExpansionEntity domain = new ClosedDomainExpansionEntity(owner, this, radius);
        owner.m_9236_().m_7967_((Entity)domain);
        SelfEmbodimentOfPerfectionEntity entity = new SelfEmbodimentOfPerfectionEntity(domain);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 pos = owner.m_20182_().m_82549_(owner.m_20289_(1.0f).m_82490_((double)entity.m_20206_())).m_82546_(look.m_82542_((double)entity.m_20205_(), 0.0, (double)entity.m_20205_()));
        entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        double d0 = look.m_165924_();
        entity.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
        entity.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
        owner.m_9236_().m_7967_((Entity)entity);
        return domain;
    }

    @Override
    public List<Block> getBlocks() {
        return List.of((Block)JJKBlocks.SELF_EMBODIMENT_OF_PERFECTION.get());
    }
}

