/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.ClientWrapper;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.item.cursed_tool.PolearmStaffItem;
import radon.jujutsu_kaisen.item.cursed_tool.SlaughterDemonItem;
import radon.jujutsu_kaisen.item.cursed_tool.SteelGauntletItem;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Punch
extends Ability
implements Ability.ICharged {
    private static final float DAMAGE = 7.5f;
    private static final double RANGE = 7.5;
    private static final double LAUNCH_POWER = 3.0;
    private static final int STAGGER = 0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        if (owner.m_21023_((MobEffect)JJKEffects.STAGGER.get())) {
            return false;
        }
        if (!owner.m_142582_((Entity)target) || (double)owner.m_20270_((Entity)target) > 7.0) {
            return false;
        }
        return HelperMethods.RANDOM.m_188503_(1) == 0;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean isMelee() {
        return true;
    }

    @Override
    public void run(LivingEntity owner) {
        if (!(owner instanceof Player) || !owner.m_9236_().f_46443_) {
            return;
        }
        ClientWrapper.setOverlayMessage((Component)Component.m_237110_((String)String.format("chat.%s.charge", "jujutsu_kaisen"), (Object[])new Object[]{Math.round((float)Math.min(20, this.getCharge(owner)) / 20.0f * 100.0f)}), false);
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        return super.isStillUsable(owner);
    }

    @Override
    public boolean onRelease(LivingEntity owner) {
        if (owner.m_21023_((MobEffect)JJKEffects.STAGGER.get())) {
            return false;
        }
        owner.m_6674_(InteractionHand.MAIN_HAND);
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        float power = (float)Math.min(20, this.getCharge(owner)) / 20.0f;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        float num = 3.0f;
        if ((double)power >= 0.25) {
            num = 4.0f;
        }
        double newRange = 7.5;
        int newStagger = 0;
        int dash = cap.getDash();
        if (dash > 0) {
            num += 2.0f;
            newRange += 1.5;
            Vec3 pos = owner.m_146892_().m_82549_(look);
            owner.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12517_, SoundSource.MASTER, 1.0f, 1.5f);
        }
        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof PolearmStaffItem) {
            newRange += 1.2;
        }
        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SlaughterDemonItem) {
            newStagger = (int)((double)newStagger + 10.0);
        }
        if (cap.getSpeedStacks() > 0) {
            newRange = 7.5 + (double)cap.getSpeedStacks() / 2.0;
        }
        ArrayList targets = new ArrayList();
        Level level1 = owner.m_9236_();
        int i = 0;
        while ((float)i < num) {
            double finalNewRange = newRange;
            int finalStagger = newStagger;
            cap.delayTickEvent(() -> {
                Vec3 offset = owner.m_146892_().m_82549_(look.m_82490_(finalNewRange / 2.0 - 2.0));
                for (LivingEntity entity2 : owner.m_9236_().m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)offset, (double)finalNewRange, (double)(finalNewRange + 2.0), (double)finalNewRange), entity -> entity != owner)) {
                    Player player;
                    Player player2;
                    int cooldown;
                    boolean found = false;
                    for (String target : targets) {
                        if (target != entity2.m_20149_()) continue;
                        found = true;
                    }
                    if (found) continue;
                    targets.add(entity2.m_20149_());
                    if (entity2.getCapability(SorcererDataHandler.INSTANCE).isPresent() && entity2.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        ISorcererData victimCap = (ISorcererData)entity2.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        ISorcererData attackerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        if (victimCap.hasPact(owner.m_20148_(), Pact.FRIENDS) && attackerCap.hasPact(entity2.m_20148_(), Pact.FRIENDS)) continue;
                    }
                    if (level1 instanceof ServerLevel) {
                        Vec3 center = entity2.m_20182_().m_82520_(0.0, (double)(entity2.m_20206_() / 2.0f), 0.0);
                        entity2.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11913_, SoundSource.MASTER, 0.9f, 1.2f);
                        entity2.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11928_, SoundSource.MASTER, 1.5f, 1.3f);
                        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
                            entity2.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_12600_, SoundSource.MASTER, 1.5f, 0.8f);
                        }
                        ((ServerLevel)level1).m_8767_((ParticleOptions)ParticleTypes.f_123747_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                    }
                    int tim = 8;
                    if (power == 1.0f) {
                        if (!cap.hasToggled((Ability)JJKAbilities.RATIO_RULE.get()) && !JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION)) {
                            cap.moreBlackFlash(true);
                        }
                        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
                            tim = 10;
                        }
                        cap.delayTickEvent(() -> cap.moreBlackFlash(false), 3);
                    }
                    if ((double)power >= 0.65 && (double)power <= 0.75 && cap.hasToggled((Ability)JJKAbilities.RATIO_RULE.get()) && (cooldown = cap.getRemainingCooldown((Ability)JJKAbilities.RATIO_RULE.get())) <= 0) {
                        cap.moreBlackFlash(true);
                        tim = 14;
                        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
                            tim = 16;
                        }
                        cap.delayTickEvent(() -> cap.moreBlackFlash(false), 3);
                    }
                    float newDMG = 7.5f;
                    if (owner instanceof Player) {
                        player2 = (Player)owner;
                    } else {
                        newDMG /= 1.65f;
                    }
                    if (owner instanceof Player) {
                        player2 = (Player)owner;
                        player2.m_5706_((Entity)entity2);
                    } else {
                        owner.m_7327_((Entity)entity2);
                    }
                    entity2.f_19802_ = 0;
                    float newPower = (float)(3.0 * (0.8 + 0.4 * (double)power));
                    newDMG *= (float)(1.0 + 0.75 * (double)power);
                    if (JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION)) {
                        DamageSource damageSource;
                        if (owner instanceof Player) {
                            player = (Player)owner;
                            damageSource = owner.m_269291_().m_269075_(player);
                        } else {
                            damageSource = owner.m_269291_().m_269333_(owner);
                        }
                        if (!entity2.m_6469_(damageSource, newDMG * 1.25f * this.getPower(owner))) continue;
                        entity2.m_20256_(look.m_82490_((double)(newPower * (1.0f + this.getPower(owner) * 0.1f) * 1.5f)).m_82542_(1.0, 0.25, 1.0));
                        entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), tim, 0, false, false, false));
                        entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), finalStagger, 0, false, false, false));
                        continue;
                    }
                    if (!entity2.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), newDMG * this.getPower(owner))) continue;
                    if (owner instanceof Player) {
                        player = (Player)owner;
                        entity2.m_20256_(look.m_82490_((double)(newPower * (1.0f + this.getPower(owner) * 0.1f))).m_82542_(1.0, 0.25, 1.0));
                    } else {
                        entity2.m_20256_(look.m_82490_((double)(newPower * (1.0f + this.getPower(owner) * 0.1f))).m_82542_(2.0, 0.5, 2.0));
                    }
                    entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), tim, 0, false, false, false));
                    entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), finalStagger, 0, false, false, false));
                }
            }, i * 1);
            ++i;
        }
        if (dash > 0) {
            Vec3 pos = owner.m_146892_().m_82549_(look.m_82490_(2.5));
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < 4; ++i) {
            Vec3 pos = owner.m_146892_().m_82549_(look.m_82490_(2.5));
            Item item = owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            level2.m_8767_((ParticleOptions)(item instanceof SwordItem && !(item instanceof SteelGauntletItem) ? ParticleTypes.f_123766_ : ParticleTypes.f_123796_), pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < 4; ++i) {
            Vec3 pos = owner.m_146892_().m_82549_(look.m_82490_(2.5));
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
        }
        Vec3 pos = owner.m_146892_().m_82549_(look);
        owner.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12317_, SoundSource.MASTER, 1.0f, 1.0f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.2f);
        owner.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_184214_, SoundSource.MASTER, 1.0f, 1.6f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.4f);
        return true;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return owner.m_6117_() ? Ability.Status.FAILURE : super.isTriggerable(owner);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcerer sorcerer;
        return (!(owner instanceof ISorcerer) || (sorcerer = (ISorcerer)owner).hasMeleeAttack() && sorcerer.hasArms()) && super.isValid(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 0.0f : 20.0f;
    }

    @Override
    public int getCooldown() {
        return 10;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.MELEE;
    }
}

