/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.chant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.BindingVow;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.chant.ServerChantHandler;
import radon.jujutsu_kaisen.client.chant.ClientChantHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;

public class ChantHandler {
    public static boolean isChanted(LivingEntity owner, Ability ability) {
        return ChantHandler.getChant(owner, ability) > 0.0f;
    }

    public static float getOutput(LivingEntity owner, Ability ability) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getOutput() + ChantHandler.getChant(owner, ability);
    }

    public static float getChant(LivingEntity owner, Ability ability) {
        List<String> messages = owner.m_9236_().f_46443_ ? ClientChantHandler.getMessages() : ServerChantHandler.getMessages(owner);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ArrayList<String> chants = new ArrayList<String>(cap.getFirstChants(ability));
        if (chants.isEmpty()) {
            return 0.0f;
        }
        if (messages.isEmpty()) {
            return 0.0f;
        }
        int count = 0;
        int length = 0;
        float countMult = 0.5f;
        float lengthMult = 1.15f;
        float outputMod = 0.0f;
        if (cap.hasBindingVow(BindingVow.CHANTER)) {
            outputMod += -0.3f;
            countMult = 1.0f;
            lengthMult = 1.65f;
        }
        int index = 0;
        for (String chant : messages) {
            if (index == chants.size()) break;
            if (!chant.equals(chants.get(index))) continue;
            ++index;
            ++count;
            length += chant.length();
        }
        float countFactor = (float)count / (float)((Integer)ConfigHolder.SERVER.maximumChantCount.get()).intValue();
        float lengthFactor = (float)length / (float)((Integer)ConfigHolder.SERVER.maximumChantCount.get() * (Integer)ConfigHolder.SERVER.maximumChantLength.get());
        if (cap.hasBindingVow(BindingVow.RISK) && owner.m_21223_() / owner.m_21233_() < 0.25f && ability.isTechnique()) {
            outputMod = (float)((double)outputMod + 0.4);
        }
        return countMult * countFactor + lengthMult * lengthFactor + outputMod;
    }

    @Nullable
    public static String next(LivingEntity owner) {
        List<String> messages;
        List<String> list = messages = owner.m_9236_().f_46443_ ? ClientChantHandler.getMessages() : ServerChantHandler.getMessages(owner);
        if (messages.isEmpty()) {
            return null;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Ability ability = cap.getAbility(messages.get(messages.size() - 1));
        if (ability != null) {
            ArrayList<String> chants = new ArrayList<String>(cap.getFirstChants(ability));
            if (chants.size() == 1) {
                return null;
            }
            int index = 0;
            Iterator iter = chants.iterator();
            for (String chant : messages) {
                if (!iter.hasNext() || !chant.equals(iter.next())) break;
                ++index;
            }
            return index < chants.size() ? (String)chants.get(index) : null;
        }
        return null;
    }
}

