/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.mixin.client.ILevelRendererAccessor;

public class SkyHandler {
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private static ClientLevel overworld;
    private static TextureTarget target;
    private static int skyWidth;
    private static int skyHeight;
    private static VertexBuffer skyBuffer;
    private static final Lazy<VertexBuffer> optional;

    public static TextureTarget getTarget() {
        return target;
    }

    private static VertexBuffer getSky() {
        if (skyBuffer == null) {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            BufferBuilder.RenderedBuffer rendered = SkyHandler.buildSkyDisc(buffer);
            skyBuffer.m_85921_();
            skyBuffer.m_231221_(rendered);
            VertexBuffer.m_85931_();
        }
        return skyBuffer;
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder pBuilder) {
        float height = 16.0f;
        float f = Math.signum(height) * 512.0f;
        RenderSystem.setShader(GameRenderer::m_172808_);
        pBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        pBuilder.m_5483_(0.0, (double)height, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            pBuilder.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)height, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return pBuilder.m_231175_();
    }

    public static void renderSky(PoseStack poseStack, float partialTick, Matrix4f matrix4f) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int ww = window.m_85441_();
        int wh = window.m_85442_();
        if (ww <= 0 || wh <= 0) {
            return;
        }
        boolean update = false;
        if (target == null || skyWidth != ww || skyHeight != wh) {
            update = true;
            skyWidth = ww;
            skyHeight = wh;
        }
        if (update) {
            if (target != null) {
                target.m_83930_();
            }
            target = new TextureTarget(skyWidth, skyHeight, true, Minecraft.f_91002_);
        }
        mc.f_91063_.m_172775_(false);
        target.m_83947_(true);
        RenderTarget current = mc.m_91385_();
        SkyHandler.renderActualSky(poseStack, partialTick, matrix4f);
        mc.f_91063_.m_172775_(true);
        target.m_83963_();
        target.m_83970_();
        current.m_83947_(true);
    }

    public static void renderActualSky(PoseStack poseStack, float partialTick, Matrix4f projection) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91073_ != null && mc.f_91074_ != null);
        if (overworld == null) {
            ClientPacketListener conn = mc.m_91403_();
            if (conn == null) {
                return;
            }
            Holder.Reference holder = mc.f_91073_.m_9598_().m_175515_(Registries.f_256787_).m_246971_(BuiltinDimensionTypes.f_223538_);
            overworld = new ClientLevel(conn, new ClientLevel.ClientLevelData(Difficulty.NORMAL, false, false), Level.f_46428_, (Holder)holder, 0, 0, () -> ((Minecraft)mc).m_91307_(), mc.f_91060_, false, 0L);
            overworld.m_104746_(1000L);
        }
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 pos = camera.m_90583_();
        FogRenderer.m_109018_((Camera)camera, (float)partialTick, (ClientLevel)overworld, (int)mc.f_91066_.m_193772_(), (float)mc.f_91063_.m_109131_(partialTick));
        FogRenderer.m_109036_();
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        float distance = mc.f_91063_.m_109152_();
        boolean fog = overworld.m_104583_().m_5781_(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82481_)) || mc.f_91065_.m_93090_().m_93715_();
        FogRenderer.m_234172_((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)distance, (boolean)fog, (float)partialTick);
        RenderSystem.setShader(GameRenderer::m_172808_);
        Vec3 vec3 = mc.f_91063_.m_109153_().m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        Vec3 vec31 = CubicSampler.m_130038_((Vec3)vec3, (p_194161_, p_194162_, p_194163_) -> Vec3.m_82501_((int)7907327));
        float f1 = Mth.m_14089_((float)(overworld.m_46942_(partialTick) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.f_82479_ * f1;
        float f3 = (float)vec31.f_82480_ * f1;
        float f4 = (float)vec31.f_82481_ * f1;
        FogRenderer.m_109036_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f2, (float)f3, (float)f4, (float)1.0f);
        ShaderInstance shader = RenderSystem.getShader();
        ((VertexBuffer)optional.get()).m_85921_();
        ((VertexBuffer)optional.get()).m_253207_(poseStack.m_85850_().m_252922_(), projection, shader);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        float[] color = overworld.m_104583_().m_7518_(overworld.m_46942_(partialTick), partialTick);
        if (color != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f5 = Mth.m_14031_((float)overworld.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f5));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f6 = color[0];
            float f7 = color[1];
            float f8 = color[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f6, f7, f8, color[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f9 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f10 = Mth.m_14031_((float)f9);
                float f11 = Mth.m_14089_((float)f9);
                buffer.m_252986_(matrix4f, f10 * 120.0f, f11 * 120.0f, -f11 * 40.0f * color[3]).m_85950_(color[0], color[1], color[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            poseStack.m_85849_();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(overworld.m_46942_(partialTick) * 360.0f));
        Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
        float f12 = 30.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        if (mc.f_91066_.m_92174_() != CloudStatus.OFF) {
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ClientLevel previous = ((ILevelRendererAccessor)mc.f_91060_).getLevelAccessor();
            ((ILevelRendererAccessor)mc.f_91060_).setLevelAccessor(overworld);
            mc.f_91060_.m_253054_(poseStack, projection, partialTick, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            ((ILevelRendererAccessor)mc.f_91060_).setLevelAccessor(previous);
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        FogRenderer.m_109017_();
    }

    static {
        skyWidth = -1;
        skyHeight = -1;
        optional = Lazy.of(SkyHandler::getSky);
    }
}

