/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.ParticleColors;

public class CursedEnergyOverlay {
    public static ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/gui/overlay/energy_bar.png");
    private static final float SCALE = 0.6f;
    public static IGuiOverlay OVERLAY = (gui, graphics, partialTicks, width, height) -> {
        int cooldown;
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ISorcererData cap = (ISorcererData)mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.6f, 0.6f, 0.6f);
        ArrayList<MutableComponent> above = new ArrayList<MutableComponent>();
        above.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.output", "jujutsu_kaisen"), (Object[])new Object[]{Math.round(cap.getOutput() * 100.0f)}));
        above.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.experience", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(cap.getExperience())}));
        if (cap.hasTechnique(CursedTechnique.IDLE_TRANSFIGURATION)) {
            above.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.transfigured_souls", "jujutsu_kaisen"), (Object[])new Object[]{cap.getTransfiguredSouls()}));
        }
        int aboveY = 26;
        for (Component component : above) {
            graphics.m_280430_(gui.m_93082_(), component, Math.round(33.333332f), Math.round((float)aboveY * 1.6666666f), 0xFFFFFF);
            Objects.requireNonNull(mc.f_91062_);
            aboveY += 9 - 1;
        }
        graphics.m_280168_().m_85849_();
        if (cap.getEnergy() > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            Vector3f color = cap.isInZone() ? ParticleColors.BLACK_FLASH : Vec3.m_82501_((int)cap.getCursedEnergyColor()).m_252839_();
            RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)1.0f);
            graphics.m_280163_(TEXTURE, 20, aboveY, 0.0f, 0.0f, 93, 10, 93, 18);
            float f = cap.getEnergy() / cap.getMaxEnergy() * 94.0f;
            graphics.m_280163_(TEXTURE, 20, aboveY + 1, 0.0f, 10.0f, (int)f, 8, 93, 18);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.6f, 0.6f, 0.6f);
        if (cap.getEnergy() > 0.0f) {
            graphics.m_280488_(gui.m_93082_(), String.format("%.1f / %.1f", Float.valueOf(cap.getEnergy()), Float.valueOf(cap.getMaxEnergy())), Math.round(38.333332f), Math.round(((float)aboveY + 3.0f) * 1.6666666f), 0xFFFFFF);
            aboveY += 4;
        }
        ArrayList<MutableComponent> below = new ArrayList<MutableComponent>();
        int n = cap.getBurnout();
        if (n > 0) {
            below.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.burnout", "jujutsu_kaisen"), (Object[])new Object[]{Math.round((float)n / 20.0f)}).m_130940_(ChatFormatting.DARK_RED));
        }
        for (Ability ability : cap.getToggled()) {
            int cooldown2;
            if (!(ability instanceof Ability.IAttack) || (cooldown2 = cap.getRemainingCooldown(ability)) <= 0) continue;
            below.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.cooldown", "jujutsu_kaisen"), (Object[])new Object[]{ability.getName(), Math.round((float)cooldown2 / 20.0f)}));
        }
        Ability channeled = cap.getChanneled();
        if (channeled instanceof Ability.IAttack && (cooldown = cap.getRemainingCooldown(channeled)) > 0) {
            below.add(Component.m_237110_((String)String.format("gui.%s.cursed_energy_overlay.cooldown", "jujutsu_kaisen"), (Object[])new Object[]{channeled.getName(), Math.round((float)cooldown / 20.0f)}));
        }
        Objects.requireNonNull(mc.f_91062_);
        int belowY = aboveY + 9;
        for (Component component : below) {
            graphics.m_280430_(gui.m_93082_(), component, Math.round(33.333332f), Math.round((float)belowY * 1.6666666f), 0xFFFFFF);
            Objects.requireNonNull(mc.f_91062_);
            belowY += 9;
        }
        graphics.m_280168_().m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    };
}

