/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;
import radon.jujutsu_kaisen.client.particle.JJKParticles;
import radon.jujutsu_kaisen.client.render.entity.effect.BoltEffect;
import radon.jujutsu_kaisen.client.render.entity.effect.BoltRenderer;
import radon.jujutsu_kaisen.util.RotationUtil;

public class EmittingLightningParticle
extends TextureSheetParticle {
    private final Vector3f color;
    private final BoltRenderer renderer;

    protected EmittingLightningParticle(ClientLevel pLevel, double pX, double pY, double pZ, EmittingLightningParticleOptions options) {
        super(pLevel, pX, pY, pZ);
        this.color = options.color();
        this.f_107663_ = Math.max(options.scalar(), (this.f_107223_.m_188501_() - 0.5f) * options.scalar());
        this.f_107225_ = options.lifetime();
        this.renderer = new BoltRenderer();
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        PoseStack pose = new PoseStack();
        Vec3 offset = this.getPos().m_82549_(RotationUtil.calculateViewVector((this.f_107223_.m_188501_() - 0.5f) * 360.0f, (this.f_107223_.m_188501_() - 0.5f) * 360.0f).m_82490_((double)(this.f_107223_.m_188501_() * this.f_107663_)));
        double d0 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double d1 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double d2 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_);
        Vec3 cam = pRenderInfo.m_90583_();
        pose.m_85836_();
        pose.m_85837_(d0 - cam.f_82479_, d1 - cam.f_82480_, d2 - cam.f_82481_);
        Vec3 start = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 end = new Vec3(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        BoltEffect.BoltRenderInfo info = new BoltEffect.BoltRenderInfo(0.0f, 0.075f, 0.0f, 0.0f, new Vector4f(this.color.x, this.color.y, this.color.z, 0.8f), 1.8f);
        BoltEffect bolt = new BoltEffect(info, start, end, (int)Math.sqrt(start.m_82554_(end) * 100.0)).size(0.05f).lifespan(1).fade(BoltEffect.FadeFunction.NONE).spawn(BoltEffect.SpawnFunction.NO_DELAY);
        this.renderer.update(null, bolt, pPartialTicks);
        pose.m_85837_(-this.f_107212_, -this.f_107213_, -this.f_107214_);
        this.renderer.render(pPartialTicks, pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        pose.m_85849_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public record EmittingLightningParticleOptions(Vector3f color, float scalar, int lifetime) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<EmittingLightningParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<EmittingLightningParticleOptions>(){

            @NotNull
            public EmittingLightningParticleOptions fromCommand(@NotNull ParticleType<EmittingLightningParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                Vector3f color = EmittingLightningParticleOptions.readColorVector3f(reader);
                reader.expect(' ');
                return new EmittingLightningParticleOptions(color, reader.readFloat(), reader.readInt());
            }

            @NotNull
            public EmittingLightningParticleOptions fromNetwork(@NotNull ParticleType<EmittingLightningParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new EmittingLightningParticleOptions(EmittingLightningParticleOptions.readColorFromNetwork(buf), buf.readFloat(), buf.readInt());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.EMITTING_LIGHTNING.get();
        }

        public static Vector3f readColorVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f0 = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new Vector3f(f0, f1, f2);
        }

        public static Vector3f readColorFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeFloat(this.color.x);
            buf.writeFloat(this.color.y);
            buf.writeFloat(this.color.z);
            buf.writeFloat(this.scalar);
            buf.writeInt(this.lifetime);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x), Float.valueOf(this.color.y), Float.valueOf(this.color.z), Float.valueOf(this.scalar), this.lifetime);
        }
    }

    public static class Provider
    implements ParticleProvider<EmittingLightningParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public EmittingLightningParticle createParticle(@NotNull EmittingLightningParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EmittingLightningParticle(level, x, y, z, options);
        }
    }
}

