/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.particle.JJKParticleRenderTypes;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class VaporParticle<T extends VaporParticleOptions>
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final boolean glow;

    protected VaporParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, T options, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.f_107225_ = ((VaporParticleOptions)options).lifetime();
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        Vector3f color = ((VaporParticleOptions)options).color();
        this.f_107227_ = color.x;
        this.f_107228_ = color.y;
        this.f_107229_ = color.z;
        this.f_107230_ = ((VaporParticleOptions)options).opacity();
        this.glow = ((VaporParticleOptions)options).glow();
        this.f_107663_ = Math.max(((VaporParticleOptions)options).scalar(), (this.f_107223_.m_188501_() - 0.5f) * ((VaporParticleOptions)options).scalar());
        this.sprites = pSprites;
        this.m_108337_(this.sprites.m_213979_(this.f_107223_));
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108337_(this.sprites.m_213979_(this.f_107223_));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return this.glow ? JJKParticleRenderTypes.GLOW : JJKParticleRenderTypes.TRANSLUCENT;
    }

    public record VaporParticleOptions(Vector3f color, float scalar, float opacity, boolean glow, int lifetime) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<VaporParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<VaporParticleOptions>(){

            @NotNull
            public VaporParticleOptions fromCommand(@NotNull ParticleType<VaporParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                Vector3f color = VaporParticleOptions.readColorVector3f(reader);
                reader.expect(' ');
                return new VaporParticleOptions(color, reader.readFloat(), reader.readFloat(), reader.readBoolean(), reader.readInt());
            }

            @NotNull
            public VaporParticleOptions fromNetwork(@NotNull ParticleType<VaporParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new VaporParticleOptions(VaporParticleOptions.readColorFromNetwork(buf), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readInt());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.VAPOR.get();
        }

        public static Vector3f readColorVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f0 = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new Vector3f(f0, f1, f2);
        }

        public static Vector3f readColorFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeFloat(this.color.x);
            buf.writeFloat(this.color.y);
            buf.writeFloat(this.color.z);
            buf.writeFloat(this.scalar);
            buf.writeFloat(this.opacity);
            buf.writeBoolean(this.glow);
            buf.writeInt(this.lifetime);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %b %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x), Float.valueOf(this.color.y), Float.valueOf(this.color.z), Float.valueOf(this.scalar), Float.valueOf(this.opacity), this.glow, this.lifetime);
        }
    }

    public static class Provider
    implements ParticleProvider<VaporParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(@NotNull VaporParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new VaporParticle<VaporParticleOptions>(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType, this.sprites);
        }
    }
}

