/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.client.model.entity.CursedEnergyBlastModel;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.entity.effect.CursedEnergyBlastEntity;

public class CursedEnergyBlastRenderer
extends EntityRenderer<CursedEnergyBlastEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/cursed_energy_blast.png");
    private final CursedEnergyBlastModel model;

    public CursedEnergyBlastRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new CursedEnergyBlastModel(pContext.m_174023_(CursedEnergyBlastModel.LAYER));
    }

    public void render(CursedEnergyBlastEntity pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Entity entity = pEntity.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vector3f color = ParticleColors.getCursedEnergyColor((Entity)owner);
        float age = (float)pEntity.getTime() + pPartialTick;
        float fraction = age / 25.0f;
        float opacity = (float)Math.max((1.0 - Math.pow(fraction, 4.0)) * (double)0.4f, (double)1.0E-5f);
        pPoseStack.m_85836_();
        float yaw = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19859_, (float)pEntity.m_146908_());
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        VertexConsumer consumer = pBuffer.m_6299_(JJKRenderTypes.energy(this.getTextureLocation(pEntity)));
        this.model.setupAnim(pEntity, 0.0f, 0.0f, age, 0.0f, 0.0f);
        this.model.m_7695_(pPoseStack, consumer, pPackedLight, OverlayTexture.f_118083_, color.x, color.y, color.z, opacity);
        pPoseStack.m_85849_();
    }

    protected int getBlockLightLevel(@NotNull CursedEnergyBlastEntity pEntity, @NotNull BlockPos pPos) {
        return 15;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CursedEnergyBlastEntity pEntity) {
        return TEXTURE;
    }
}

