/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.entity.projectile.RedProjectile;

public class RedRenderer
extends EntityRenderer<RedProjectile> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/red.png");
    private static final RenderType RENDER_TYPE = JJKRenderTypes.glow(TEXTURE);
    private static final float SIZE = 0.1f;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public RedRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(RedProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, (double)(pEntity.m_20206_() / 2.0f), 0.0);
        if (pEntity.getTime() < 20) {
            this.renderLight(pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        } else {
            this.renderBall(pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        }
        pPoseStack.m_85849_();
    }

    private void renderBall(RedProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Minecraft mc = Minecraft.m_91087_();
        Entity viewer = mc.m_91288_();
        if (viewer == null) {
            return;
        }
        float yaw = viewer.m_5675_(pPartialTick);
        float pitch = viewer.m_5686_(pPartialTick);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(360.0f - yaw));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(pitch + 90.0f));
        VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(RENDER_TYPE);
        Matrix4f pose = pPoseStack.m_85850_().m_252922_();
        consumer.m_252986_(pose, -0.1f, 0.0f, -0.1f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, -0.1f, 0.0f, 0.1f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 0.1f, 0.0f, 0.1f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 0.1f, 0.0f, -0.1f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        mc.m_91269_().m_110104_().m_109912_(RENDER_TYPE);
    }

    private void renderLight(RedProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        float f0 = ((float)pEntity.getTime() + pPartialTick) / 20.0f;
        float f1 = Math.min(f0 > 0.8f ? (f0 - 0.8f) / 0.2f : 0.0f, 1.0f);
        RandomSource random = RandomSource.m_216335_((long)432L);
        VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110502_());
        float scale = pEntity.m_20205_() * pEntity.m_20206_() * 2.0f;
        int i = 0;
        while ((float)i < (f0 + f0 * f0) / 2.0f * 60.0f) {
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f));
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f + f0 * 90.0f));
            float f2 = random.m_188501_() * 20.0f + 5.0f + f1 * 10.0f;
            float f3 = random.m_188501_() * 2.0f + 1.0f + f1 * 2.0f;
            Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
            int j = (int)(255.0f * (1.0f - f1));
            RedRenderer.vertex01(consumer, matrix4f, j);
            RedRenderer.vertex2(consumer, matrix4f, f2, f3, scale);
            RedRenderer.vertex3(consumer, matrix4f, f2, f3, scale);
            RedRenderer.vertex01(consumer, matrix4f, j);
            RedRenderer.vertex3(consumer, matrix4f, f2, f3, scale);
            RedRenderer.vertex4(consumer, matrix4f, f2, f3, scale);
            RedRenderer.vertex01(consumer, matrix4f, j);
            RedRenderer.vertex4(consumer, matrix4f, f2, f3, scale);
            RedRenderer.vertex2(consumer, matrix4f, f2, f3, scale);
            ++i;
        }
    }

    private static void vertex01(VertexConsumer pConsumer, Matrix4f pMatrix, int pAlpha) {
        pConsumer.m_252986_(pMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, pAlpha).m_5752_();
    }

    private static void vertex2(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253704_, float p_253701_, float pScale) {
        pConsumer.m_252986_(pMatrix, -HALF_SQRT_3 * p_253701_ * pScale, p_253704_ * pScale, -0.5f * p_253701_ * pScale).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253729_, float p_254030_, float scaleFactor) {
        pConsumer.m_252986_(pMatrix, HALF_SQRT_3 * p_254030_ * scaleFactor, p_253729_ * scaleFactor, -0.5f * p_254030_ * scaleFactor).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253649_, float p_253694_, float scaleFactor) {
        pConsumer.m_252986_(pMatrix, 0.0f, p_253649_ * scaleFactor, p_253694_ * scaleFactor).m_6122_(255, 0, 0, 0).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull RedProjectile pEntity) {
        return TextureAtlas.f_118259_;
    }

    protected int getBlockLightLevel(@NotNull RedProjectile pEntity, @NotNull BlockPos pPos) {
        return 15;
    }
}

