/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import radon.jujutsu_kaisen.client.slice.AABBCollider;
import radon.jujutsu_kaisen.client.slice.Collider;
import radon.jujutsu_kaisen.client.slice.Contact;
import radon.jujutsu_kaisen.client.slice.ContactManifold;
import radon.jujutsu_kaisen.client.slice.ConvexMeshCollider;
import radon.jujutsu_kaisen.client.slice.GJK;
import radon.jujutsu_kaisen.client.slice.LegacyMath;
import radon.jujutsu_kaisen.util.MathUtil;

public class RigidBody {
    public static final Vec3[] cardinals = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0)};
    public static final RigidBody DUMMY = new RigidBody(null){

        @Override
        public void addChunk(List<CutModelData> chunk) {
        }

        @Override
        public void solveContacts(float step) {
        }

        @Override
        public void impulse(Vec3 force, Vec3 position) {
        }

        @Override
        public void updateOrientation() {
        }

        @Override
        public void updateGlobalCentroidFromPosition() {
        }

        @Override
        public void updatePositionFromGlobalCentroid() {
        }

        @Override
        public void step(float step) {
        }

        @Override
        public Vec3 globalToLocalPos(Vec3 global) {
            return global;
        }

        @Override
        public Vec3 localToGlobalPos(Vec3 global) {
            return global;
        }

        @Override
        public Vec3 globalToLocalVec(Vec3 global) {
            return global;
        }

        @Override
        public Vec3 localToGlobalVec(Vec3 local) {
            return local;
        }

        @Override
        public void addLinearVelocity(Vec3 velocity) {
        }

        @Override
        public void addAngularVelocity(Vec3 velocity) {
        }

        @Override
        public void addContact(Contact contact) {
        }
    };
    private static final ResourceLocation BLOOD;
    private final List<CutModelData> chunk = new ArrayList<CutModelData>();
    private final List<RigidBody> parts = new ArrayList<RigidBody>();
    public Level level;
    public AABB bounds;
    public List<Collider> colliders = new ArrayList<Collider>();
    public List<AABB> colliderBoundingBoxes = new ArrayList<AABB>();
    public Vec3 position = Vec3.f_82478_;
    public Vec3 globalCentroid = Vec3.f_82478_;
    public Matrix3f rotation = new Matrix3f();
    public Matrix3f invRotation;
    public Vec3 prevPosition = Vec3.f_82478_;
    public Quaternionf prevRotation = new Quaternionf();
    public Vec3 linearVelocity = Vec3.f_82478_;
    public Vec3 angularVelocity = Vec3.f_82478_;
    public Vec3 force = Vec3.f_82478_;
    public Vec3 torque = Vec3.f_82478_;
    public float mass;
    public float invMass;
    public Matrix3f localInertiaTensor;
    public Matrix3f invLocalInertiaTensor;
    public Matrix3f invGlobalInertiaTensor;
    public float friction = 0.5f;
    public float restitution = 0.0f;
    public Vec3 localCentroid;
    public ContactManifold contacts = new ContactManifold();

    public RigidBody(Level level) {
        this.level = level;
    }

    public RigidBody(Level level, double x, double y, double z) {
        this(level);
        this.position = new Vec3(x, y, z);
    }

    public void addChunk(List<CutModelData> chunk) {
        this.chunk.addAll(chunk);
        for (CutModelData data : chunk) {
            this.colliders.add(data.collider);
        }
        this.localCentroid = Vec3.f_82478_;
        this.mass = 0.0f;
        for (Collider collider : this.colliders) {
            this.mass += collider.mass;
            this.localCentroid = this.localCentroid.m_82549_(collider.localCentroid.m_82490_((double)collider.mass));
        }
        this.invMass = 1.0f / this.mass;
        this.localCentroid = this.localCentroid.m_82490_((double)this.invMass);
        this.localInertiaTensor = new Matrix3f().zero();
        for (Collider collider : this.colliders) {
            Vec3 colliderToLocal = this.localCentroid.m_82546_(collider.localCentroid);
            double dot = colliderToLocal.m_82526_(colliderToLocal);
            Matrix3f outer = MathUtil.outer(colliderToLocal, colliderToLocal);
            Matrix3f colliderToLocalMat = new Matrix3f();
            colliderToLocalMat.scale((float)dot);
            colliderToLocalMat.sub((Matrix3fc)outer);
            colliderToLocalMat.scale(collider.mass);
            Matrix3f cLocalIT = new Matrix3f((Matrix3fc)collider.localInertiaTensor);
            cLocalIT.add((Matrix3fc)colliderToLocalMat);
            this.localInertiaTensor.add((Matrix3fc)cLocalIT);
        }
        this.invLocalInertiaTensor = new Matrix3f((Matrix3fc)this.localInertiaTensor);
        LegacyMath.invert(this.invLocalInertiaTensor);
        this.invGlobalInertiaTensor = new Matrix3f();
        this.updateOrientation();
        this.updateGlobalCentroidFromPosition();
        this.prevPosition = this.position;
        this.updateAABBs();
    }

    public void addParts(List<RigidBody> parts) {
        this.parts.addAll(parts);
    }

    public void tick() {
        for (int i = 0; i < this.contacts.contactCount; ++i) {
            this.contacts.removeContact(i);
        }
        this.setPrevData();
        int time = 8;
        float step = 0.05f / (float)time;
        for (int i = 0; i < time; ++i) {
            this.step(step);
        }
    }

    public void step(float step) {
        Collider a;
        int i;
        this.contacts.update();
        for (VoxelShape shape : this.level.m_186434_(null, this.bounds)) {
            if (shape.m_83281_()) continue;
            for (i = 0; i < this.colliders.size(); ++i) {
                a = this.colliders.get(i);
                if (!this.colliderBoundingBoxes.get(i).m_82381_(shape.m_83215_())) continue;
                AABBCollider b = new AABBCollider(shape.m_83215_());
                GJK.GJKInfo info = GJK.colliding(this, null, a, b);
                if (info.result != GJK.Result.COLLIDING) continue;
                this.contacts.addContact(new Contact(this, null, a, b, info));
            }
        }
        for (RigidBody part : this.parts) {
            if (part == this) continue;
            for (i = 0; i < this.colliders.size(); ++i) {
                a = this.colliders.get(i);
                for (int j = 0; j < part.colliders.size(); ++j) {
                    if (!this.colliderBoundingBoxes.get(i).m_82381_(part.colliderBoundingBoxes.get(j))) continue;
                    Collider b = part.colliders.get(j);
                    GJK.GJKInfo info = GJK.colliding(this, part, a, b);
                    if (info.result != GJK.Result.COLLIDING) continue;
                    this.contacts.addContact(new Contact(this, part, a, b, info));
                }
            }
        }
        this.solveContacts(step);
        this.integrateVelocityAndPosition(step);
    }

    public void integrateVelocityAndPosition(float step) {
        this.linearVelocity = this.linearVelocity.m_82549_(this.force.m_82490_((double)(this.invMass * step)));
        this.angularVelocity = this.angularVelocity.m_82549_(MathUtil.transform(this.torque.m_82490_((double)step), this.invGlobalInertiaTensor));
        this.force = Vec3.f_82478_;
        this.torque = Vec3.f_82478_;
        this.globalCentroid = this.globalCentroid.m_82549_(this.linearVelocity.m_82490_((double)step));
        if (this.angularVelocity.m_82556_() > 0.0) {
            Vec3 axis = LegacyMath.normalize(this.angularVelocity);
            double angle = (double)((float)this.angularVelocity.m_82553_()) * (double)step;
            Matrix3f turn = new Matrix3f();
            LegacyMath.set(turn, new AxisAngle4f((float)angle, (Vector3fc)axis.m_252839_()));
            LegacyMath.mul(turn, this.rotation);
            this.rotation = turn;
            this.updateOrientation();
        }
        this.updatePositionFromGlobalCentroid();
        this.updateAABBs();
        this.addLinearVelocity(new Vec3(0.0, -9.81 * (double)step, 0.0));
    }

    public void setPrevData() {
        this.prevPosition = this.position;
        MathUtil.quatFromMat(this.prevRotation, this.rotation);
    }

    public void addContact(Contact contact) {
        this.contacts.addContact(contact);
    }

    public void solveContacts(float step) {
        for (int i = 0; i < this.contacts.contactCount; ++i) {
            this.contacts.contacts[i].init(step);
        }
        int velocityIterations = 4;
        for (int i = 0; i < velocityIterations; ++i) {
            for (int j = 0; j < this.contacts.contactCount; ++j) {
                this.contacts.contacts[j].solve();
            }
        }
    }

    public Vec3 localToGlobalPos(Vec3 global) {
        return MathUtil.transform(global, this.rotation).m_82549_(this.position);
    }

    public Vec3 globalToLocalPos(Vec3 global) {
        return MathUtil.transform(global.m_82546_(this.position), this.invRotation);
    }

    public Vec3 localToGlobalVec(Vec3 local) {
        return MathUtil.transform(local, this.rotation);
    }

    public Vec3 globalToLocalVec(Vec3 global) {
        return MathUtil.transform(global, this.invRotation);
    }

    public void addLinearVelocity(Vec3 velocity) {
        this.linearVelocity = this.linearVelocity.m_82549_(velocity);
    }

    public void addAngularVelocity(Vec3 velocity) {
        this.angularVelocity = this.angularVelocity.m_82549_(velocity);
    }

    public void impulse(Vec3 force, Vec3 position) {
        this.force = this.force.m_82549_(force);
        this.torque = this.torque.m_82549_(position.m_82546_(this.globalCentroid).m_82537_(force));
    }

    public void impulseVelocity(Vec3 force, Vec3 position) {
        this.linearVelocity = this.linearVelocity.m_82549_(force.m_82490_((double)this.invMass));
        this.angularVelocity = this.angularVelocity.m_82549_(MathUtil.transform(position.m_82546_(this.globalCentroid).m_82537_(force), this.invGlobalInertiaTensor));
    }

    public void impulseVelocityDirect(Vec3 force, Vec3 position) {
        this.linearVelocity = this.linearVelocity.m_82549_(force);
        this.angularVelocity = this.angularVelocity.m_82549_(position.m_82546_(this.globalCentroid).m_82537_(force));
    }

    public void updateOrientation() {
        Quaternionf quaternionf = new Quaternionf();
        MathUtil.quatFromMat(quaternionf, this.rotation);
        quaternionf.normalize();
        MathUtil.matFromQuat(this.rotation, quaternionf);
        this.invRotation = new Matrix3f((Matrix3fc)this.rotation).transpose();
        this.invGlobalInertiaTensor.set((Matrix3fc)this.invRotation);
        LegacyMath.mul(this.invGlobalInertiaTensor, this.invLocalInertiaTensor);
        LegacyMath.mul(this.invGlobalInertiaTensor, this.rotation);
    }

    public void updatePositionFromGlobalCentroid() {
        this.position = this.globalCentroid.m_82549_(MathUtil.transform(this.localCentroid.m_82548_(), this.rotation));
    }

    public void updateGlobalCentroidFromPosition() {
        this.globalCentroid = MathUtil.transform(this.localCentroid, this.rotation).m_82549_(this.position);
    }

    public void updateAABBs() {
        this.colliderBoundingBoxes.clear();
        double tMaxZ = -1.7976931348623157E308;
        double tMaxY = -1.7976931348623157E308;
        double tMaxX = -1.7976931348623157E308;
        double tMinZ = Double.MAX_VALUE;
        double tMinY = Double.MAX_VALUE;
        double tMinX = Double.MAX_VALUE;
        for (Collider collider : this.colliders) {
            double maxX = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[0]).f_82479_;
            double maxY = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[1]).f_82480_;
            double maxZ = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[2]).f_82481_;
            double minX = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[3]).f_82479_;
            double minY = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[4]).f_82480_;
            double minZ = GJK.localSupport((RigidBody)this, (Collider)collider, (Vec3)RigidBody.cardinals[5]).f_82481_;
            this.colliderBoundingBoxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            tMaxX = Math.max(tMaxX, maxX);
            tMaxY = Math.max(tMaxY, maxY);
            tMaxZ = Math.max(tMaxZ, maxZ);
            tMinX = Math.min(tMinX, minX);
            tMinY = Math.min(tMinY, minY);
            tMinZ = Math.min(tMinZ, minZ);
        }
        this.bounds = new AABB(tMinX, tMinY, tMinZ, tMaxX, tMaxY, tMaxZ);
    }

    public void render(PoseStack poseStack, int packedLight, float partialTicks) {
        poseStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        double d0 = Mth.m_14139_((double)partialTicks, (double)this.prevPosition.f_82479_, (double)this.position.f_82479_);
        double d1 = Mth.m_14139_((double)partialTicks, (double)this.prevPosition.f_82480_, (double)this.position.f_82480_);
        double d2 = Mth.m_14139_((double)partialTicks, (double)this.prevPosition.f_82481_, (double)this.position.f_82481_);
        Vec3 cam = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(d0 - cam.f_82479_, d1 - cam.f_82480_, d2 - cam.f_82481_);
        Quaternionf quaternionf = new Quaternionf();
        MathUtil.quatFromMat(quaternionf, this.rotation);
        quaternionf.slerp((Quaternionfc)this.prevRotation, 1.0f - partialTicks);
        quaternionf.normalize();
        poseStack.m_252781_(quaternionf);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        for (CutModelData data : this.chunk) {
            builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
            data.data.tessellate(builder, matrix4f, packedLight);
            data.type.m_276775_(builder, RenderSystem.getVertexSorting());
        }
        for (CutModelData data : this.chunk) {
            if (data.cap == null) continue;
            RenderType type = RenderType.m_110458_((ResourceLocation)BLOOD);
            builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
            data.cap.tessellate(builder, matrix4f, packedLight);
            type.m_276775_(builder, RenderSystem.getVertexSorting());
        }
        poseStack.m_85849_();
    }

    static {
        RigidBody.DUMMY.invRotation = new Matrix3f((Matrix3fc)RigidBody.DUMMY.rotation);
        RigidBody.DUMMY.localInertiaTensor = new Matrix3f().zero();
        RigidBody.DUMMY.invLocalInertiaTensor = new Matrix3f().zero();
        RigidBody.DUMMY.invGlobalInertiaTensor = new Matrix3f().zero();
        RigidBody.DUMMY.localCentroid = Vec3.f_82478_;
        RigidBody.DUMMY.globalCentroid = Vec3.f_82478_;
        BLOOD = new ResourceLocation("jujutsu_kaisen", "textures/misc/blood.png");
    }

    public static class CutModelData {
        public RenderType type;
        public VertexData data;
        public VertexData cap;
        public boolean flip;
        public final ConvexMeshCollider collider;

        public CutModelData(RenderType type, VertexData data, VertexData cap, boolean flip, ConvexMeshCollider collider) {
            this.type = type;
            this.data = data;
            this.cap = cap;
            this.flip = flip;
            this.collider = collider;
        }
    }

    public static class VertexData {
        public Vec3[] positions;
        public int @Nullable [] indices;
        public float[] uv;
        public int[] color;

        public void tessellate(BufferBuilder builder, Matrix4f matrix4f, int packedLight) {
            this.tessellate(builder, matrix4f, false, packedLight);
        }

        public void tessellate(BufferBuilder builder, Matrix4f matrix4f, boolean flip, int packedLight) {
            if (this.indices == null) {
                return;
            }
            for (int i = 0; i < this.indices.length; i += 3) {
                Vec3 a = this.positions[this.indices[i]];
                Vec3 b = this.positions[this.indices[i + 1]];
                Vec3 c = this.positions[this.indices[i + 2]];
                int tOB = 1;
                int tOC = 2;
                if (flip) {
                    Vec3 tmp = b;
                    b = c;
                    c = tmp;
                    tOB = 2;
                    tOC = 1;
                }
                Vec3 normalized = b.m_82546_(a).m_82537_(c.m_82546_(a)).m_82541_();
                builder.m_252986_(matrix4f, (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_).m_193479_(this.color[i]).m_7421_(this.uv[i * 2], this.uv[i * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)normalized.f_82479_, (float)normalized.f_82480_, (float)normalized.f_82481_).m_5752_();
                builder.m_252986_(matrix4f, (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_).m_193479_(this.color[i + tOB]).m_7421_(this.uv[(i + tOB) * 2], this.uv[(i + tOB) * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)normalized.f_82479_, (float)normalized.f_82480_, (float)normalized.f_82481_).m_5752_();
                builder.m_252986_(matrix4f, (float)c.f_82479_, (float)c.f_82480_, (float)c.f_82481_).m_193479_(this.color[i + tOC]).m_7421_(this.uv[(i + tOC) * 2], this.uv[(i + tOC) * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)normalized.f_82479_, (float)normalized.f_82480_, (float)normalized.f_82481_).m_5752_();
            }
        }

        public float[] vertices() {
            float[] vertices = new float[this.positions.length * 3];
            for (int i = 0; i < this.positions.length; ++i) {
                Vec3 pos = this.positions[i];
                vertices[i * 3] = (float)pos.f_82479_;
                vertices[i * 3 + 1] = (float)pos.f_82480_;
                vertices[i * 3 + 2] = (float)pos.f_82481_;
            }
            return vertices;
        }
    }

    public static class Triangle {
        public TexVertex p1;
        public TexVertex p2;
        public TexVertex p3;

        public Triangle(Vec3 p1, Vec3 p2, Vec3 p3) {
            this.p1 = new TexVertex(p1);
            this.p2 = new TexVertex(p2);
            this.p3 = new TexVertex(p3);
        }

        public Triangle(Vec3 p1, Vec3 p2, Vec3 p3, float[] uv, int[] color) {
            this.p1 = new TexVertex(p1, uv[0], uv[1], color[0]);
            this.p2 = new TexVertex(p2, uv[2], uv[3], color[1]);
            this.p3 = new TexVertex(p3, uv[4], uv[5], color[2]);
        }

        public static class TexVertex {
            public Vec3 pos;
            public float u;
            public float v;
            public int color;

            public TexVertex(Vec3 pos) {
                this.pos = pos;
            }

            public TexVertex(Vec3 pos, float u, float v, int color) {
                this.pos = pos;
                this.u = u;
                this.v = v;
                this.color = color;
            }
        }
    }
}

