/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.base;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.entity.VeilBlockEntity;
import radon.jujutsu_kaisen.block.entity.VeilRodBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.SimpleDomainEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionCenterEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public abstract class DomainExpansionEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(DomainExpansionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int OFFSET = 5;
    public static final int INITIAL_COST = 1000;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;
    public DomainExpansion ability;
    protected boolean first = true;
    private float scale;
    private boolean instant;

    protected DomainExpansionEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public DomainExpansionEntity(EntityType<?> pType, LivingEntity owner, DomainExpansion ability) {
        super(pType, owner.m_9236_());
        this.setOwner(owner);
        this.instant = false;
        this.ability = ability;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return;
        }
        this.scale = cap.getDomainSize();
    }

    public boolean checkVeil(BlockPos pos, LivingEntity domainOwner) {
        BlockEntity be = this.m_9236_().m_7702_(pos);
        if (!(be instanceof VeilBlockEntity)) {
            return false;
        }
        VeilBlockEntity veilBe = (VeilBlockEntity)be;
        BlockPos parentPos = veilBe.getParent();
        if (parentPos == null) {
            return false;
        }
        BlockEntity parentBE = this.m_9236_().m_7702_(parentPos);
        if (!(parentBE instanceof VeilRodBlockEntity)) {
            return false;
        }
        VeilRodBlockEntity rodBE = (VeilRodBlockEntity)parentBE;
        ISorcererData domainCap = domainOwner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
        if (domainCap == null) {
            return false;
        }
        if (domainCap.getExperience() >= rodBE.getExperience()) {
            this.m_9236_().m_46961_(rodBE.m_58899_(), true);
            return true;
        }
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            VeilHandler.addDomain((ResourceKey<Level>)this.m_9236_().m_46472_(), this.m_20148_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void setInstant(boolean yn) {
        this.instant = true;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128359_("ability", JJKAbilities.getKey(this.ability).toString());
        pCompound.m_128379_("first", this.first);
        pCompound.m_128405_("time", this.getTime());
        pCompound.m_128350_("scale", this.scale);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.ability = (DomainExpansion)JJKAbilities.getValue(new ResourceLocation(pCompound.m_128461_("ability")));
        this.first = pCompound.m_128471_("first");
        this.setTime(pCompound.m_128451_("time"));
        this.scale = pCompound.m_128457_("scale");
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public List<LivingEntity> getAffected() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.getBounds(), this::isAffected);
    }

    public boolean hasSureHitEffect() {
        return true;
    }

    public abstract boolean checkSureHitEffect();

    public Ability getAbility() {
        return this.ability;
    }

    protected boolean m_20073_() {
        return false;
    }

    @Nullable
    public DomainExpansionCenterEntity getDomainCenter() {
        List collisions = this.m_9236_().m_45976_(DomainExpansionCenterEntity.class, this.getBounds());
        for (DomainExpansionCenterEntity collision : collisions) {
            if (collision.getDomain() != this) continue;
            return collision;
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public abstract AABB getBounds();

    public abstract boolean isInsideBarrier(BlockPos var1);

    public boolean m_5830_() {
        return false;
    }

    public void m_8119_() {
        LivingEntity owner;
        block8: {
            block9: {
                this.setTime(this.getTime() + 1);
                owner = this.getOwner();
                if (this.m_9236_().f_46443_ || owner == null) break block8;
                if (!(owner instanceof Player)) break block9;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_) break block8;
            }
            if (this.getTime() == 1 && !this.instant) {
                ISorcererData cap = owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
                float cost = this.getAbility().getRealCost(owner, 1000.0f);
                if (cap == null || cap.getEnergy() - cost < 0.0f) {
                    this.m_146870_();
                    return;
                }
                cap.useEnergy(cost);
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
            }
        }
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && JJKAbilities.hasToggled(owner, this.ability))) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    public boolean isAffected(BlockPos pos) {
        return this.isInsideBarrier(pos);
    }

    public boolean isAffected(LivingEntity victim) {
        TamableAnimal tamable;
        LivingEntity owner = this.getOwner();
        if (owner == null || victim == owner) {
            return false;
        }
        if (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21824_() && tamable.m_269323_() == owner) {
            return false;
        }
        if (!owner.m_6779_(victim)) {
            return false;
        }
        if (victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            SimpleDomainEntity simple;
            ITenShadowsData victimTenShadowsCap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData victimSorcererCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (victim instanceof MahoragaEntity && victimTenShadowsCap.isAdaptedTo(this.ability)) {
                return false;
            }
            if (victimSorcererCap.hasToggled((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get())) {
                return false;
            }
            if (victimSorcererCap.hasToggled((Ability)JJKAbilities.SIMPLE_DOMAIN.get()) && (simple = victimSorcererCap.getSummonByClass(SimpleDomainEntity.class)) != null) {
                ISorcererData ownerSorcererCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                simple.m_6469_(JJKDamageSources.indirectJujutsuAttack(this, owner, this.ability), ownerSorcererCap.getAbilityPower() * 10.0f);
            }
            for (SimpleDomainEntity simple2 : this.m_9236_().m_45976_(SimpleDomainEntity.class, AABB.m_165882_((Vec3)victim.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (!(victim.m_20270_((Entity)simple2) < simple2.getRadius())) continue;
                return false;
            }
        }
        return this.isAffected(victim.m_20183_());
    }

    public boolean shouldCollapse(float strength) {
        return strength / this.getStrength() > 2.5f;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * DomainExpansionEntity.m_20150_()) * d0;
    }

    public float getStrength() {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return 0.0f;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        float domainMod = 1.0f;
        if (JJKAbilities.CHIMERA_SHADOW_GARDEN.get() == this.ability) {
            domainMod = (float)((double)domainMod * 0.66);
        }
        return cap.getAbilityPower() * (owner.m_21223_() / owner.m_21233_()) * domainMod;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

