/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.base;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class SummonEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(SummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    protected SummonEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            this.m_6858_(new Vec3((double)passenger.f_20900_, (double)passenger.f_20901_, (double)passenger.f_20902_).m_82556_() > 0.01);
        } else {
            this.m_6858_(this.m_20184_().m_82556_() > 0.01 && this.f_21342_.m_24999_() > 1.0);
        }
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        return (!this.m_21824_() || pTarget != this.m_269323_()) && super.m_6779_(pTarget);
    }

    protected void m_6475_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        LivingEntity attacker;
        super.m_6475_(pDamageSource, pDamageAmount);
        Entity entity = pDamageSource.m_7639_();
        if (entity instanceof LivingEntity && this.m_6779_(attacker = (LivingEntity)entity)) {
            this.m_6710_(attacker);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity m_269323_() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public void onAddedToWorld() {
        ICommandable commandable;
        SummonEntity summonEntity;
        super.onAddedToWorld();
        SummonEntity summonEntity2 = this;
        if (summonEntity2 instanceof ISorcerer) {
            ISorcerer sorcerer = (ISorcerer)((Object)summonEntity2);
            this.getCapability(SorcererDataHandler.INSTANCE).ifPresent(sorcerer::init);
        }
        if ((summonEntity = this) instanceof ICommandable && (commandable = (ICommandable)((Object)summonEntity)).canChangeTarget() && (summonEntity = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)summonEntity;
            PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237115_((String)String.format("chat.%s.set_target_info", "jujutsu_kaisen")), false), player);
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("tame", this.m_21824_());
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128405_("time", this.getTime());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_7105_(pCompound.m_128471_("tame"));
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.setTime(pCompound.m_128451_("time"));
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        LivingEntity owner = this.m_269323_();
        if (!this.m_9236_().f_46443_ && this.m_21824_() && (owner == null || owner.m_213877_() || !owner.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getCost(LivingEntity owner) {
        return this.getAbility().getCost(owner);
    }

    public abstract Summon<?> getAbility();

    protected boolean shouldToggleOnDeath() {
        return true;
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        Summon<?> ability;
        LivingEntity owner;
        super.m_142687_(pReason);
        if (this.shouldToggleOnDeath() && (owner = this.m_269323_()) != null && (ability = this.getAbility()) != null && JJKAbilities.hasToggled(owner, ability)) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.toggle(ability);
        }
    }
}

