/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.effect.BodyRepelSegmentEntity;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BodyRepelEntity
extends Projectile
implements GeoEntity {
    public static EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(BodyRepelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double HITBOX_RADIUS = 1.5;
    private static final double HITBOX_HEIGHT = 1.5;
    private AABB hitbox;
    private static final double SPEED = 3.0;
    private static final float DAMAGE = 10.0f;
    private static final float EXPLOSIVE_POWER = 2.0f;
    private static final float MAX_EXPLOSION = 15.0f;
    private static final int DURATION = 60;
    private static final int MAX_SEGMENTS = 24;
    private final BodyRepelSegmentEntity[] segments;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int souls;

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)1);
    }

    private void initializeSegments() {
        Vec3 prevPos = this.m_20182_();
        for (int i = 0; i < this.segments.length; ++i) {
            BodyRepelSegmentEntity seg = this.segments[i];
            double offsetY = prevPos.f_82480_ - (double)((float)(i + 1) * seg.m_20206_());
            seg.m_6034_(prevPos.f_82479_, offsetY, prevPos.f_82481_);
            prevPos = seg.m_20182_();
        }
    }

    public BodyRepelEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.segments = new BodyRepelSegmentEntity[24];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new BodyRepelSegmentEntity(this, i);
        }
        this.m_20234_(f_19843_.getAndAdd(this.segments.length + 1) + 1);
        this.initializeSegments();
    }

    public BodyRepelEntity(LivingEntity pShooter, int souls) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.BODY_REPEL.get()), pShooter.m_9236_());
        this.m_5602_((Entity)pShooter);
        this.souls = souls;
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)pShooter);
        this.m_20219_(pShooter.m_146892_());
        Vec3 dest = new Vec3(pShooter.m_20185_(), pShooter.m_20188_() - (double)(this.m_20206_() / 2.0f), pShooter.m_20189_()).m_82549_(look);
        EntityUtil.offset((Entity)this, pShooter.m_20154_(), dest);
        this.m_146922_(pShooter.m_6080_());
        double speed = 3.0 * (1.0 + 3.0 * (double)this.souls / 10.0);
        this.m_20256_(look.m_82490_(speed));
        Level level = pShooter.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        level2.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("time", this.getTime());
        pCompound.m_128405_("souls", this.souls);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTime(pCompound.m_128451_("time"));
        this.souls = pCompound.m_128451_("souls");
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_20234_(id + i + 1);
        }
    }

    public PartEntity<?> @NotNull [] getParts() {
        return this.segments;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_) {
            for (BodyRepelSegmentEntity seg : this.segments) {
                seg.m_6074_();
            }
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_8119_();
            BodyRepelEntity leader = i == 0 ? this : this.segments[i - 1];
            Vec3 follow = i == 0 ? leader.m_20182_().m_82520_(0.0, (double)(this.m_20206_() - this.segments[i].m_20206_()), 0.0).m_82549_(this.m_20184_()) : leader.m_20182_();
            Vec3 diff = new Vec3(this.segments[i].m_20185_() - follow.f_82479_, this.segments[i].m_20186_() - follow.f_82480_, this.segments[i].m_20189_() - follow.f_82481_).m_82541_();
            double f = leader.m_20205_() / 2.0f + this.segments[i].m_20205_() / 2.0f;
            double destX = follow.f_82479_ + f * diff.f_82479_;
            double destY = follow.f_82480_ + f * diff.f_82480_;
            double destZ = follow.f_82481_ + f * diff.f_82481_;
            this.segments[i].m_6034_(destX, destY, destZ);
            double d0 = diff.m_165924_();
            this.segments[i].m_19915_((float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 180.0 / Math.PI) + 90.0f, (float)(Math.atan2(diff.f_82480_, d0) * 180.0 / Math.PI));
        }
    }

    public boolean isMultipartEntity() {
        return this.segments != null;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    private boolean isSelfOrSegment(Entity entity) {
        if (entity == this || entity == this.m_19749_()) {
            return true;
        }
        for (BodyRepelSegmentEntity seg : this.segments) {
            if (entity != seg) continue;
            return true;
        }
        return false;
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        Entity owner = this.m_19749_();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_())) {
            this.m_146870_();
        } else {
            Level level;
            super.m_8119_();
            if (this.getTime() == 2 && owner != null) {
                owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_215672_, SoundSource.MASTER, 1.0f, 0.5f);
                owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12404_, SoundSource.MASTER, 2.0f, 1.0f);
            }
            if (this.getTime() >= 60) {
                this.m_146870_();
                return;
            }
            this.moveSegments();
            HitResult hit = ProjectileUtil.m_278158_((Entity)this, target -> false);
            if (hit.m_6662_() == HitResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hit)) {
                this.m_8060_((BlockHitResult)hit);
            }
            Vec3 pos = this.m_20182_();
            this.hitbox = new AABB(pos.f_82479_ - 1.5, pos.f_82480_, pos.f_82481_ - 1.5, pos.f_82479_ + 1.5, pos.f_82480_ + 1.5, pos.f_82481_ + 1.5);
            List targets = this.m_9236_().m_6249_((Entity)this, this.hitbox, x$0 -> this.m_5603_((Entity)x$0));
            if (owner != null) {
                for (Entity target2 : targets) {
                    if (this.isSelfOrSegment(target2)) continue;
                    ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    if (target2 == owner && !ownerCap.hasSelfHit()) {
                        return;
                    }
                    if (!(owner instanceof LivingEntity)) continue;
                    LivingEntity livingOwner = (LivingEntity)owner;
                    ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), target2.m_20182_().m_82520_(0.0, (double)(target2.m_20206_() / 2.0f), 0.0), Math.min(15.0f, 2.0f * Ability.getPower((Ability)JJKAbilities.BODY_REPEL.get(), livingOwner) * (0.05f + 0.05f * (float)this.souls)), 20, this.getRealDamage(), livingOwner, JJKDamageSources.indirectJujutsuAttack((Entity)this, livingOwner, (Ability)JJKAbilities.BODY_REPEL.get()), false);
                    this.m_146870_();
                    return;
                }
            }
            this.m_20101_();
            Vec3 movement = this.m_20184_();
            double d0 = this.m_20185_() + movement.f_82479_;
            double d1 = this.m_20186_() + movement.f_82480_;
            double d2 = this.m_20189_() + movement.f_82481_;
            this.m_6034_(d0, d1, d2);
            if (owner == null || !((level = owner.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * BodyRepelEntity.m_20150_()) * d0;
    }

    public float getRealDamage() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            return Ability.getPower((Ability)JJKAbilities.BODY_REPEL.get(), owner) * (0.2f + 0.09f * (float)this.souls / 5.0f);
        }
        return 0.0f;
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingOwner = (LivingEntity)entity;
        Vec3 location = pResult.m_82450_();
        ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), location, Math.min(15.0f, 2.0f * Ability.getPower((Ability)JJKAbilities.BODY_REPEL.get(), livingOwner) * (0.05f + 0.05f * (float)this.souls)), 20, this.getRealDamage(), livingOwner, JJKDamageSources.indirectJujutsuAttack((Entity)this, livingOwner, (Ability)JJKAbilities.BODY_REPEL.get()), false);
        this.m_146870_();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, this.m_20184_(), 0.0);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.m_7678_(pPacket.m_131500_(), pPacket.m_131501_(), pPacket.m_131502_(), pPacket.m_237567_(), pPacket.m_237566_());
        this.m_20334_(pPacket.m_131503_(), pPacket.m_131504_(), pPacket.m_131505_());
    }
}

