/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionCenterEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class FilmGaugeProjectile
extends JujutsuProjectile {
    private static final EntityDataAccessor<Vector3f> DATA_START = SynchedEntityData.m_135353_(FilmGaugeProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final float SPEED = 3.0f;
    private static final float DAMAGE = 10.0f;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private LivingEntity cachedTarget;

    public FilmGaugeProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public FilmGaugeProjectile(LivingEntity owner, float power, LivingEntity target, DomainExpansionCenterEntity center) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.FILM_GAUGE.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
        this.setTarget(target);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(center);
        EntityUtil.offset((Entity)this, look, new Vec3(center.m_20185_(), center.m_20186_() + (double)(center.m_20206_() / 2.0f) - (double)(this.m_20206_() / 2.0f), center.m_20189_()).m_82549_(look));
        this.f_19804_.m_135381_(DATA_START, (Object)this.m_20182_().m_252839_());
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null) {
            this.targetUUID = target.m_20148_();
            this.cachedTarget = target;
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedTarget = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    public Vec3 getStart() {
        return new Vec3((Vector3f)this.f_19804_.m_135370_(DATA_START));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_START, (Object)Vec3.f_82478_.m_252839_());
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        Vector3f start = (Vector3f)this.f_19804_.m_135370_(DATA_START);
        pCompound.m_128350_("start_x", start.x);
        pCompound.m_128350_("start_y", start.y);
        pCompound.m_128350_("start_z", start.z);
        if (this.targetUUID != null) {
            pCompound.m_128362_("target", this.targetUUID);
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_START, (Object)new Vector3f(pCompound.m_128457_("start_x"), pCompound.m_128457_("start_y"), pCompound.m_128457_("start_z")));
        if (pCompound.m_128403_("target")) {
            this.targetUUID = pCompound.m_128342_("target");
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = pResult.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Entity entity3 = this.m_19749_();
        if (entity3 instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity3;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
            if (domain == null) {
                return;
            }
            if (entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack(domain, owner, null), 10.0f * this.getPower())) {
                entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 20, 1, false, false, false));
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            LivingEntity owner;
            ISorcererData cap;
            DomainExpansionEntity domain;
            Entity entity = this.m_19749_();
            if (!(!(entity instanceof LivingEntity) || (domain = (cap = (ISorcererData)(owner = (LivingEntity)entity).getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getSummonByClass(DomainExpansionEntity.class)) != null && domain.checkSureHitEffect() && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.TIME_CELL_MOON_PALACE.get()))) {
                this.m_146870_();
            }
            if ((target = this.getTarget()) != null && !target.m_21224_() && !target.m_213877_()) {
                Vec3 src = this.m_20182_();
                Vec3 dst = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
                this.m_20256_(dst.m_82546_(src).m_82541_().m_82490_(3.0));
            } else {
                this.m_146870_();
            }
        }
        super.m_8119_();
    }
}

