/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AgitoEntity
extends TenShadowsSummon {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");

    public AgitoEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public AgitoEntity(LivingEntity owner) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.AGITO.get()), owner.m_9236_());
        this.m_7105_(true);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean canChant() {
        return true;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_()) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, pPlayer.m_20182_().m_82520_(0.0, (double)(pPlayer.m_20206_() / 2.0f), 0.0));
            this.m_6710_(null);
            if (AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.OUTPUT_RCT.get()) == Ability.Status.SUCCESS) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22276_, 44.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22281_, 24.0);
    }

    private PlayState walkRunIdlePredicate(AnimationState<AgitoEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState swingPredicate(AnimationState<AgitoEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)0.8f);
        }
    }

    @Override
    public void onRemovedFromWorld() {
        LivingEntity owner;
        super.onRemovedFromWorld();
        if (this.m_21824_() && (owner = this.m_269323_()) != null) {
            this.getCapability(TenShadowsDataHandler.INSTANCE).ifPresent(srcCap -> owner.getCapability(TenShadowsDataHandler.INSTANCE).ifPresent(dstCap -> dstCap.addAdapted(srcCap.getAdapted())));
        }
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.AGITO.get();
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.NUE_LIGHTNING.get());
    }

    @Override
    public List<Ability> getUnlocked() {
        return List.of((Ability)JJKAbilities.RCT1.get(), (Ability)JJKAbilities.RCT2.get(), (Ability)JJKAbilities.RCT3.get(), (Ability)JJKAbilities.OUTPUT_RCT.get(), (Ability)JJKAbilities.QUICKDASH.get());
    }
}

