/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.IJumpInputListener;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.NueEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NueTotalityEntity
extends TenShadowsSummon
implements PlayerRideable,
IJumpInputListener {
    private static final EntityDataAccessor<Integer> DATA_FLIGHT = SynchedEntityData.m_135353_(NueTotalityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation FLY_1 = RawAnimation.begin().thenLoop("move.fly_1");
    private static final RawAnimation FLY_2 = RawAnimation.begin().thenLoop("move.fly_2");
    private static final RawAnimation FLY_3 = RawAnimation.begin().thenLoop("move.fly_3");
    private static final RawAnimation SWING = RawAnimation.begin().thenLoop("attack.swing");
    private static final RawAnimation FLIGHT_FEET = RawAnimation.begin().thenLoop("misc.flight_feet");
    private static final RawAnimation GRAB_FEET = RawAnimation.begin().thenLoop("misc.grab_feet");
    private boolean jump;

    public NueTotalityEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public NueTotalityEntity(LivingEntity owner) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.NUE_TOTALITY.get()), owner.m_9236_());
        this.m_7105_(true);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return true;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return false;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLIGHT, (Object)0);
    }

    @Override
    protected void m_8024_() {
        Vec3 movement;
        super.m_8024_();
        LivingEntity passenger = this.m_6688_();
        Vec3 vec3 = movement = passenger == null ? this.m_20184_() : new Vec3((double)passenger.f_20900_, 0.0, (double)passenger.f_20902_);
        if (this.jump) {
            this.setFlight(NueEntity.Flight.ASCEND);
        } else if (movement.m_82553_() > 1.0) {
            this.setFlight(NueEntity.Flight.SPRINT);
        } else {
            this.setFlight(NueEntity.Flight.NORMAL);
        }
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_213877_() && target.m_6084_()) {
            if (this.m_20186_() >= target.m_20186_() + (double)(this.m_20206_() * 1.4f) && Math.sqrt(this.m_20275_(target.m_20185_(), this.m_20186_(), target.m_20189_())) <= 5.0) {
                if (this.f_19796_.m_188503_(5) != 0) {
                    return;
                }
                if (AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.NUE_TOTALITY_LIGHTNING.get()) == Ability.Status.SUCCESS) {
                    this.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else if (!this.m_20160_()) {
                this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_() + (double)(this.m_20206_() * 1.4f), target.m_20189_(), (double)this.m_274460_());
            }
        }
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        if (super.m_7327_(pEntity)) {
            if (pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                Ability lightning = (Ability)JJKAbilities.NUE_LIGHTNING.get();
                ((Ability.ITenShadowsAttack)((Object)lightning)).perform((LivingEntity)this, living);
            }
            return true;
        }
        return false;
    }

    protected float m_274460_() {
        return this.m_5448_() == null || this.m_20160_() ? 0.15f : 0.65f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22266_(Attributes.f_22280_).m_22268_(Attributes.f_22276_, 22.5);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    private NueEntity.Flight getFlight() {
        return NueEntity.Flight.values()[(Integer)this.f_19804_.m_135370_(DATA_FLIGHT)];
    }

    private void setFlight(NueEntity.Flight flight) {
        this.f_19804_.m_135381_(DATA_FLIGHT, (Object)flight.ordinal());
    }

    private PlayState feetPredicate(AnimationState<NueTotalityEntity> animationState) {
        if (this.m_20160_()) {
            return animationState.setAndContinue(GRAB_FEET);
        }
        return animationState.setAndContinue(FLIGHT_FEET);
    }

    private PlayState swingPredicate(AnimationState<NueTotalityEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState flyIdlePredicate(AnimationState<NueTotalityEntity> animationState) {
        if (animationState.isMoving()) {
            return switch (this.getFlight()) {
                case NueEntity.Flight.ASCEND -> animationState.setAndContinue(FLY_1);
                case NueEntity.Flight.SPRINT -> animationState.setAndContinue(FLY_2);
                default -> animationState.setAndContinue(FLY_3);
            };
        }
        return animationState.setAndContinue(IDLE);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fly/Idle", this::flyIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Feet", this::feetPredicate)});
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.NUE_TOTALITY.get();
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.NUE_TOTALITY_LIGHTNING.get());
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        LivingEntity passenger = this.m_6688_();
        if (passenger == null) {
            return super.m_6048_();
        }
        return -passenger.m_20206_() + 0.8f;
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        EntityDimensions dimensions = super.m_6972_(pPose);
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            return new EntityDimensions(dimensions.f_20377_, dimensions.f_20378_ + passenger.m_20206_(), dimensions.f_20379_);
        }
        return dimensions;
    }

    @NotNull
    protected AABB m_142242_() {
        AABB bounds = super.m_142242_();
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            return bounds.m_165887_(bounds.f_82289_ - (double)(passenger.m_20206_() / 2.0f) - 0.4).m_165893_(bounds.f_82292_ - (double)passenger.m_20206_() + 0.4);
        }
        return bounds;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.m_20096_()) {
            return Vec3.f_82478_;
        }
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    public boolean m_20068_() {
        return !this.m_20160_() && super.m_20068_();
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        Vec3 movement = this.m_20184_();
        if (this.jump) {
            this.m_20256_(movement.m_82520_(0.0, (double)this.m_274460_(), 0.0));
        }
    }

    @Override
    public void setJump(boolean jump) {
        this.jump = jump;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
    }
}

