/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.cursed_tool;

import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.client.render.item.NyoiStaffRenderer;
import radon.jujutsu_kaisen.entity.NyoiStaffEntity;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NyoiStaffItem
extends CursedToolItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public NyoiStaffItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @Override
    public SorcererGrade getGrade() {
        return SorcererGrade.SPECIAL_GRADE;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext pContext) {
        BlockPlaceContext ctx = new BlockPlaceContext(pContext);
        Player player = ctx.m_43723_();
        if (!ctx.m_7059_() || ctx.m_43719_() != Direction.UP || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = ctx.m_43722_();
        NyoiStaffEntity staff = new NyoiStaffEntity((LivingEntity)player, stack, Vec3.m_272021_((Vec3i)ctx.m_8083_(), (double)0.5, (double)0.0, (double)0.5));
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getNature() == CursedEnergyNature.LIGHTNING) {
            float cost = ((Ability)JJKAbilities.LIGHTNING.get()).getRealCost((LivingEntity)player) * 0.75f;
            cap.delayTickEvent(() -> {
                if (staff != null) {
                    if (!player.m_150110_().f_35937_) {
                        if (cap.getEnergy() >= cost) {
                            cap.useEnergy(cost);
                            staff.setCharged(true);
                        }
                    } else {
                        staff.setCharged(true);
                    }
                }
            }, 20);
        }
        stack.m_41774_(1);
        ctx.m_43725_().m_7967_((Entity)staff);
        return InteractionResult.m_19078_((boolean)ctx.m_43725_().f_46443_);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private NyoiStaffRenderer renderer;

            public NyoiStaffRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new NyoiStaffRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

