/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.ForestSpikeEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ForestSpikes
extends Ability {
    private static final double RANGE = 30.0;
    private static final float SPREAD = 25.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private BlockHitResult getBlockHit(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(30.0)));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)result;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            Vec3 offset = entity.m_20182_().m_82492_(0.0, 5.0, 0.0);
            return owner.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        }
        return null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit != null) {
            owner.m_9236_().m_5594_(null, hit.m_82425_(), (SoundEvent)JJKSounds.FOREST_SPIKES.get(), SoundSource.MASTER, 1.0f, 1.0f);
            Direction dir = hit.m_82434_();
            BlockPos pos = hit.m_82425_();
            for (int i = 0; i < 64; ++i) {
                ForestSpikeEntity spike = new ForestSpikeEntity(owner, this.getPower(owner));
                Vec3 center = pos.m_121945_(dir).m_252807_().m_82492_((double)dir.m_122429_() * 0.5, (double)dir.m_122430_() * 0.5, (double)dir.m_122431_() * 0.5);
                float yRot = dir.m_122435_() + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 60.0f;
                float xRot = (float)(Mth.m_14136_((double)dir.m_122430_(), (double)dir.m_122429_()) * 180.0 / 3.1415927410125732) + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 60.0f;
                switch (dir) {
                    case UP: 
                    case DOWN: {
                        xRot = -xRot;
                        break;
                    }
                    case WEST: {
                        xRot -= 180.0f;
                    }
                }
                Vec3 offset = center.m_82520_((HelperMethods.RANDOM.m_188500_() - 0.5) * 25.0, 0.0, (HelperMethods.RANDOM.m_188500_() - 0.5) * 25.0);
                spike.m_7678_(offset.f_82479_, offset.f_82480_ - (double)(spike.m_20206_() / 2.0f), offset.f_82481_, yRot, xRot);
                if (owner.m_9236_().m_8055_(BlockPos.m_274446_((Position)offset.m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)spike)))).m_60795_()) {
                    spike.m_146884_(center);
                }
                owner.m_9236_().m_7967_((Entity)spike);
            }
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 150.0f;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PLANTS;
    }
}

