/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_tides;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.projectile.EelShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.PiranhaShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.SharkShikigamiProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.FishShikigamiProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class FishShikigami
extends Ability {
    public static final double RANGE = 40.0;
    public LivingEntity enemy = null;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && !target.m_21224_() && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 40.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        LivingEntity target = this.enemy;
        float xOffset = (HelperMethods.RANDOM.m_188501_() - 0.5f) * 5.0f;
        float yOffset = owner.m_20206_() + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 5.0f;
        FishShikigamiProjectile[] projectiles = new FishShikigamiProjectile[]{new EelShikigamiProjectile(owner, this.getPower(owner) * 1.15f, target, xOffset, yOffset), new SharkShikigamiProjectile(owner, this.getPower(owner) * 1.15f, target, xOffset, yOffset), new PiranhaShikigamiProjectile(owner, this.getPower(owner) * 1.15f, target, xOffset, yOffset)};
        FishShikigamiProjectile selected = projectiles[HelperMethods.RANDOM.m_188503_(projectiles.length)];
        owner.m_9236_().m_7967_((Entity)selected);
        this.enemy = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public int getCooldown() {
        return 240;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

