/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class SoulReinforcement
extends Ability
implements Ability.IToggled {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SoulReinforcementForgeEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingDamage(LivingDamageEvent event) {
            Object jujutsu;
            DamageSource source = event.getSource();
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!victimCap.hasToggled((Ability)JJKAbilities.SOUL_REINFORCEMENT.get())) {
                return;
            }
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                    return;
                }
                ISorcererData attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (HelperMethods.isMelee(source) && (attackerCap.hasTrait(Trait.VESSEL) && attackerCap.getFingers() > 0 || attackerCap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()))) {
                    return;
                }
            }
            if (source.m_276093_(JJKDamageSources.SOUL) || source.m_276093_(JJKDamageSources.SPLIT_SOUL_KATANA) || source instanceof JJKDamageSources.JujutsuDamageSource && ((JJKDamageSources.JujutsuDamageSource)((Object)(jujutsu = (JJKDamageSources.JujutsuDamageSource)source))).getAbility() == JJKAbilities.OUTPUT_RCT.get()) {
                return;
            }
            for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)victim.m_9236_(), victim.m_20183_())) {
                if (domain.getOwner() != source.m_7639_()) continue;
                return;
            }
            float cost = event.getAmount() * 12.0f * (victimCap.hasTrait(Trait.SIX_EYES) ? ((Double)ConfigHolder.SERVER.sixEyesMult.get()).floatValue() : 1.0f);
            if (victimCap.getEnergy() < cost) {
                return;
            }
            victimCap.useEnergy(cost);
            int count = 8 + (int)(victim.m_20205_() * victim.m_20206_()) * 16;
            for (int i = 0; i < count; ++i) {
                double x = victim.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(victim.m_20205_() * 2.0f) - victim.m_20154_().m_82490_((double)0.35).f_82479_;
                double y = victim.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)victim.m_20206_();
                double z = victim.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(victim.m_20205_() * 2.0f) - victim.m_20154_().m_82490_((double)0.35).f_82481_;
                ((ServerLevel)victim.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0, 0.0, HelperMethods.RANDOM.m_188500_() * 0.1, 0.0, 1.0);
            }
            if (victim instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)victim;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(victimCap.serializeNBT()), player);
            }
            event.setCanceled(true);
        }
    }
}

