/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.projection_sorcery;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.MirageParticle;
import radon.jujutsu_kaisen.client.particle.ProjectionParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.effect.ProjectionFrameEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.ScreenFlashS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.ParticleUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ProjectionSorcery
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final double LAUNCH_POWER = 2.0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(1) == 0;
        }
        return HelperMethods.RANDOM.m_188503_(1) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        if (owner.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            return Ability.Status.FAILURE;
        }
        return super.isStillUsable(owner);
    }

    @Override
    public int getRealDuration(LivingEntity owner) {
        return 12;
    }

    private static float getYaw(Vec3 from, Vec3 to) {
        Vec3 delta = to.m_82546_(from);
        double dx = delta.f_82479_;
        double dz = delta.f_82481_;
        return -((float)Math.toDegrees(Math.atan2(dx, dz)));
    }

    @Override
    public void run(LivingEntity owner) {
        float nextYaw;
        Vec3 vec3;
        Vec3 look;
        Vec3 end;
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        List<AbstractMap.SimpleEntry<Vec3, Float>> frames = cap.getFrames();
        if (frames.size() == 24) {
            return;
        }
        int charge = this.getCharge(owner) + 1;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_((double)(charge * 4))));
        if (result.m_6662_() == HitResult.Type.MISS) {
            vec3 = end;
        } else if (result instanceof BlockHitResult) {
            BlockHitResult block = (BlockHitResult)result;
            vec3 = block.m_82425_().m_252807_().m_82520_(0.0, 0.5, 0.0);
        } else {
            vec3 = result.m_82450_();
        }
        Vec3 next = vec3;
        int index = this.getCharge(owner);
        if (index > 0 && index <= frames.size()) {
            AbstractMap.SimpleEntry<Vec3, Float> entry = frames.get(index - 1);
            Vec3 current = entry.getKey();
            nextYaw = ProjectionSorcery.getYaw(current, next);
            if (frames.size() + 1 < 24) {
                Vec3 middle = current.m_82549_(next.m_82546_(current).m_82490_(0.5));
                float middleYaw = ProjectionSorcery.getYaw(middle, next);
                cap.addFrame(middle, middleYaw);
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    ParticleUtil.sendParticle(player, new ProjectionParticle.ProjectionParticleOptions(owner.m_19879_(), middleYaw), false, middle.f_82479_, middle.f_82480_, middle.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        } else {
            nextYaw = owner.m_146908_();
        }
        cap.addFrame(next, nextYaw);
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            ParticleUtil.sendParticle(player, new ProjectionParticle.ProjectionParticleOptions(owner.m_19879_(), nextYaw), false, next.f_82479_, next.f_82480_, next.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 11.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    private static boolean isGrounded(Level level, BlockPos pos) {
        BlockHitResult hit = level.m_45547_(new ClipContext(pos.m_252807_(), pos.m_6625_(36).m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        return hit.m_6662_() == HitResult.Type.BLOCK;
    }

    @Override
    public void onStop(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ArrayList<AbstractMap.SimpleEntry<Vec3, Float>> frames = new ArrayList<AbstractMap.SimpleEntry<Vec3, Float>>(cap.getFrames());
        int delay = 0;
        int frameCount = frames.size();
        if (frameCount >= 12) {
            cap.addSpeedStack();
        }
        cap.resetFrames();
        AtomicBoolean cancelled = new AtomicBoolean();
        AtomicReference previous = new AtomicReference();
        for (AbstractMap.SimpleEntry simpleEntry : frames) {
            Vec3 frame = (Vec3)simpleEntry.getKey();
            float yaw = ((Float)simpleEntry.getValue()).floatValue();
            cap.delayTickEvent(() -> {
                boolean isOnGround;
                if (cancelled.get()) {
                    return;
                }
                owner.f_267362_.m_267771_(2.0f);
                boolean bl = isOnGround = ProjectionSorcery.isGrounded(owner.m_9236_(), owner.m_20183_()) || previous.get() != null && ProjectionSorcery.isGrounded(owner.m_9236_(), BlockPos.m_274446_((Position)((Position)previous.get())));
                if (!isOnGround && !owner.m_9236_().m_8055_(BlockPos.m_274446_((Position)frame)).m_60815_() || frame.m_82554_(owner.m_20182_()) >= 50.0 * (double)(cap.getSpeedStacks() + 1)) {
                    cancelled.set(true);
                    owner.m_9236_().m_7967_((Entity)new ProjectionFrameEntity(owner, owner, Ability.getPower((Ability)JJKAbilities.TWENTY_FOUR_FRAME_RULE.get(), owner)));
                    cap.resetSpeedStacks();
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        PacketHandler.sendToClient(new ScreenFlashS2CPacket(), player);
                    }
                    return;
                }
                Level patt7718$temp = owner.m_9236_();
                if (patt7718$temp instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)patt7718$temp;
                    level.m_8767_((ParticleOptions)new MirageParticle.MirageParticleOptions(owner.m_19879_()), owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
                }
                AABB bounds = owner.m_20191_().m_82400_(3.65);
                for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)frame, (double)bounds.m_82362_(), (double)bounds.m_82376_(), (double)bounds.m_82385_()))) {
                    owner.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 11.0f * this.getPower(owner));
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        player.m_5706_(entity);
                        continue;
                    }
                    owner.m_7327_(entity);
                }
                EnumSet<RelativeMovement> movements = EnumSet.noneOf(RelativeMovement.class);
                movements.add(RelativeMovement.X);
                movements.add(RelativeMovement.Y);
                movements.add(RelativeMovement.Z);
                movements.add(RelativeMovement.X_ROT);
                movements.add(RelativeMovement.Y_ROT);
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    player.f_8906_.m_9774_(frame.f_82479_, frame.f_82480_, frame.f_82481_, yaw, owner.m_146909_());
                } else {
                    owner.m_6034_(frame.f_82479_, frame.f_82480_, frame.f_82481_);
                    owner.m_146922_(yaw);
                }
                owner.m_20256_(owner.m_20184_().m_82542_(1.0, 0.0, 1.0));
                owner.m_6853_(true);
                previous.set(frame);
            }, delay++);
        }
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ProjectionSorceryForgeEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.getSpeedStacks() == 0) {
                return;
            }
            float speed = 1.5f;
            Vec3 pos = victim.m_20182_().m_82520_(0.0, (double)(victim.m_20206_() / 2.0f), 0.0);
            ((ServerLevel)victim.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
            victim.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)attacker);
            victim.m_20256_(look.m_82490_(2.0 * (double)speed));
            victim.f_19864_ = true;
        }
    }
}

