/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.overlay;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.util.RotationUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class SixEyesOverlay {
    public static IGuiOverlay OVERLAY = (gui, graphics, partialTicks, width, height) -> {
        Minecraft mc = gui.getMinecraft();
        assert (mc.f_91073_ != null && mc.f_91074_ != null);
        if (!mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ISorcererData cap = (ISorcererData)mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!cap.hasTrait(Trait.SIX_EYES)) {
            return;
        }
        HitResult patt1266$temp = RotationUtil.getLookAtHit((Entity)mc.f_91074_, 64.0);
        if (!(patt1266$temp instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult hit = (EntityHitResult)patt1266$temp;
        Entity patt1338$temp = hit.m_82443_();
        if (!(patt1338$temp instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)patt1338$temp;
        ClientVisualHandler.ClientData data = ClientVisualHandler.get((Entity)target);
        if (data == null) {
            return;
        }
        if (data.traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) {
            return;
        }
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        if (data.technique != null) {
            MutableComponent techniqueText = Component.m_237110_((String)String.format("gui.%s.six_eyes_overlay.cursed_technique", "jujutsu_kaisen"), (Object[])new Object[]{data.technique.getName()});
            lines.add(techniqueText);
        }
        MutableComponent gradeText = Component.m_237110_((String)String.format("gui.%s.six_eyes_overlay.grade", "jujutsu_kaisen"), (Object[])new Object[]{SorcererUtil.getGrade(data.experience).getName()});
        lines.add(gradeText);
        int offset = 0;
        for (Component component : lines) {
            if (mc.f_91062_.m_92852_((FormattedText)component) <= offset) continue;
            offset = mc.f_91062_.m_92852_((FormattedText)component);
        }
        int x = (width - offset) / 2;
        int n = lines.size() - 1;
        Objects.requireNonNull(mc.f_91062_);
        int n2 = (height - (n * 9 + 8)) / 2;
        for (Component component : lines) {
            void var14_17;
            graphics.m_280430_(gui.m_93082_(), component, x, (int)var14_17, 53503);
            Objects.requireNonNull(mc.f_91062_);
            var14_17 += 9;
        }
    };
}

