/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.widget.JJKSelectionList;

public abstract class JJKTab {
    protected final Minecraft minecraft;
    protected final JujutsuScreen screen;
    private final JJKTabType type;
    private final int index;
    private final ItemStack icon;
    private final Component title;
    private final int page;
    private final ResourceLocation background;
    private final boolean scrollable;
    protected double scrollX;
    protected double scrollY;
    protected int minX = Integer.MAX_VALUE;
    protected int minY = Integer.MAX_VALUE;
    protected int maxX = Integer.MIN_VALUE;
    protected int maxY = Integer.MIN_VALUE;
    private boolean centered;
    private final List<GuiEventListener> widgets = new ArrayList<GuiEventListener>();

    public JJKTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page, ItemStack icon, Component title, ResourceLocation background, boolean scrollable) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.type = type;
        this.index = index;
        this.page = page;
        this.icon = icon;
        this.title = title;
        this.background = background;
        this.scrollable = scrollable;
    }

    public JujutsuScreen getScreen() {
        return this.screen;
    }

    public void scroll(double pDragX, double pDragY) {
        if (!this.scrollable) {
            return;
        }
        if (this.maxX - this.minX > 234) {
            this.scrollX = Mth.m_14008_((double)(this.scrollX + pDragX), (double)(-(this.maxX - 234)), (double)0.0);
        }
        if (this.maxY - this.minY > 113) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + pDragY), (double)(-(this.maxY - 113)), (double)0.0);
        }
    }

    public void tick() {
    }

    public List<GuiEventListener> getRenderables() {
        return this.widgets;
    }

    public abstract void addWidgets();

    public void removeWidgets() {
        this.screen.removeWidgets();
        this.widgets.clear();
    }

    protected <T extends GuiEventListener & Renderable> void addRenderableWidget(@NotNull T pWidget) {
        this.widgets.add(pWidget);
        this.screen.m_142416_(pWidget);
    }

    public int getPage() {
        return this.page;
    }

    public JJKTabType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public Component getTitle() {
        return this.title;
    }

    public void drawTab(GuiGraphics pGuiGraphics, int pOffsetX, int pOffsetY, boolean pIsSelected) {
        this.type.draw(pGuiGraphics, pOffsetX, pOffsetY, pIsSelected, this.index);
    }

    public void drawIcon(GuiGraphics pGuiGraphics, int pOffsetX, int pOffsetY) {
        this.type.drawIcon(pGuiGraphics, pOffsetX, pOffsetY, this.index, this.icon);
    }

    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
    }

    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (!this.centered) {
            this.scrollX = 117.0 - (double)(this.maxX + this.minX) / 2.0;
            this.scrollY = 56.0 - (double)(this.maxY + this.minY) / 2.0;
            this.centered = true;
        }
        pGuiGraphics.m_280588_(pX, pY, pX + 234, pY + 113);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)pX, (float)pY, 0.0f);
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        for (int i1 = -1; i1 <= 15; ++i1) {
            for (int j1 = -1; j1 <= 8; ++j1) {
                pGuiGraphics.m_280163_(this.background, k + 16 * i1, l + 16 * j1, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.drawCustom(pGuiGraphics, i, j);
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280618_();
    }

    protected void drawCustom(GuiGraphics graphics, int x, int y) {
    }

    public void drawTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pWidth, int pHeight) {
        for (GuiEventListener widget : this.widgets) {
            Object entry;
            JJKSelectionList list;
            if (!(widget instanceof JJKSelectionList) || !(list = (JJKSelectionList)widget).m_5953_(pMouseX, pMouseY) || (entry = list.getMouseOver(pMouseX, pMouseY)) == null) continue;
            pGuiGraphics.m_280557_(this.minecraft.f_91062_, entry.m_142172_(), pMouseX, pMouseY);
            break;
        }
    }

    public boolean isMouseOver(int pOffsetX, int pOffsetY, double pMouseX, double pMouseY) {
        return this.type.isMouseOver(pOffsetX, pOffsetY, this.index, pMouseX, pMouseY);
    }

    public void keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
    }
}

