/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.effect.WoodSegmentEntity;
import radon.jujutsu_kaisen.util.RotationUtil;

public class WoodShieldSegmentEntity
extends WoodSegmentEntity {
    private static final int COUNT = 30;
    private boolean isDying;
    private int start;
    private WoodShieldSegmentEntity prevSegment;
    @Nullable
    private Vec3 pos;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public WoodShieldSegmentEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WoodShieldSegmentEntity(LivingEntity owner) {
        super((EntityType)JJKEntities.WOOD_SHIELD_SEGMENT.get(), owner.m_9236_());
        this.setOwner(owner);
        this.pos = owner.m_20182_();
        this.setParent(this);
        this.m_7678_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), owner.m_146909_(), owner.m_146908_());
    }

    public WoodShieldSegmentEntity(WoodShieldSegmentEntity segment, float yawOffset, float pitchOffset) {
        super(segment, yawOffset, pitchOffset);
        this.setOwner(segment.getOwner());
        this.pos = segment.m_20182_();
    }

    public WoodShieldSegmentEntity(WoodShieldSegmentEntity segment, double offsetX, double offsetY, double offsetZ, float yawOffset, float pitchOffset) {
        super(segment, offsetX, offsetY, offsetZ, yawOffset, pitchOffset);
        this.setOwner(segment.getOwner());
        this.pos = segment.m_20182_();
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.pos != null) {
            pCompound.m_128347_("pos_x", this.pos.f_82479_);
            pCompound.m_128347_("pos_y", this.pos.f_82480_);
            pCompound.m_128347_("pos_z", this.pos.f_82481_);
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.pos = new Vec3(pCompound.m_128459_("pos_x"), pCompound.m_128459_("pos_y"), pCompound.m_128459_("pos_z"));
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.isDying) {
            if (this.getTime() - this.start >= 30 - this.getIndex()) {
                this.m_146870_();
            }
            return;
        }
        LivingEntity owner = this.getOwner();
        if (!(this.m_9236_().f_46443_ || this.isDying || owner != null && !owner.m_213877_() && owner.m_6084_())) {
            if (owner == null || owner.m_213877_()) {
                this.isDying = true;
                this.start = this.getTime();
            } else if (!owner.m_6084_()) {
                this.m_146870_();
            }
        } else if (owner != null && this.pos != null) {
            if (!this.m_9236_().f_46443_ && this.getIndex() == 0 && this.getTime() - 1 == 0) {
                for (int i = 0; i < (int)Mth.m_14036_((float)(owner.m_20205_() * 5.0f), (float)6.0f, (float)22.0f); ++i) {
                    WoodShieldSegmentEntity segment;
                    Vec3 pos = new Vec3((this.f_19796_.m_188500_() - 0.5) * (double)owner.m_20205_() * 2.5, 0.0, (this.f_19796_.m_188500_() - 0.5) * (double)owner.m_20205_() * 2.5);
                    float f = RotationUtil.getYaw(this.pos.m_82546_(this.m_20182_().m_82549_(pos)));
                    segment.prevSegment = segment = new WoodShieldSegmentEntity(this, pos.f_82479_, pos.f_82480_, pos.f_82481_, f + (this.f_19796_.m_188501_() - 0.5f) * 160.0f, 80.0f);
                    this.m_9236_().m_7967_((Entity)segment);
                }
            }
            if (!this.m_9236_().f_46443_ && this.getIndex() == 1 && this.getTime() > 0 && this.getTime() <= 30) {
                float yaw = (this.f_19796_.m_188501_() - 0.5f) * 30.0f;
                int i = this.prevSegment.getIndex();
                if (i > 1) {
                    yaw = Mth.m_14177_((float)(RotationUtil.getYaw(this.pos.m_82546_(this.prevSegment.m_20182_())) - this.prevSegment.m_146908_()));
                    yaw /= owner.m_20205_() + Math.max(4.4f - (float)i * 0.075f, 1.0f);
                }
                this.prevSegment = new WoodShieldSegmentEntity(this.prevSegment, yaw, -0.5f);
                this.m_9236_().m_7967_((Entity)this.prevSegment);
            }
            owner.m_6021_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
        }
    }
}

