/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.effect.DisasterPlantEntity;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CursedBudProjectile
extends JujutsuProjectile
implements GeoEntity {
    public static final int DELAY = 20;
    private static final int DURATION = 60;
    private static final int EFFECT = 50;
    private static final double SPEED = 8.0;
    private static final float DAMAGE = 18.0f;
    private boolean plant;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CursedBudProjectile(EntityType<? extends Projectile> pType, Level level) {
        super(pType, level);
    }

    public CursedBudProjectile(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.CURSED_BUD.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    public CursedBudProjectile(LivingEntity owner, float power, DisasterPlantEntity plant) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.CURSED_BUD.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)plant);
        EntityUtil.offset((Entity)this, look, new Vec3(plant.m_20185_(), plant.m_20188_() - (double)(this.m_20206_() / 2.0f), plant.m_20189_()).m_82549_(look));
        this.m_20256_(look.m_82490_(8.0));
        this.plant = true;
    }

    public void implant(LivingEntity victim) {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (victim == owner && !cap.hasSelfHit()) {
                return;
            }
            if (victim.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.CURSED_BUD.get()), 18.0f * this.getPower()) && (JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) || JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get()))) {
                victim.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.CURSED_BUD.get(), (int)(50.0f * this.getPower()), 0));
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.implant(living);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (!this.plant) {
                if (this.getTime() < 20) {
                    if (!owner.m_6084_()) {
                        this.m_146870_();
                    } else {
                        if (this.getTime() % 5 == 0) {
                            owner.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
                    }
                } else if (this.getTime() >= 60) {
                    this.m_146870_();
                } else if (this.getTime() == 20) {
                    this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(8.0));
                }
            }
        }
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("plant", this.plant);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.plant = pCompound.m_128471_("plant");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

