/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_tides;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.block.FakeWaterDurationBlock;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.DurationBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.util.HelperMethods;

public class WaterShield
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final double RADIUS = 8.0;
    private static final double X_STEP = 0.05;
    private static final float DAMAGE = 15.0f;
    private static final float SPEED = 0.1f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return !owner.m_9236_().m_6249_((Entity)owner, owner.m_20191_().m_82400_(1.0), entity -> entity instanceof Projectile).isEmpty();
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_183634_();
        Vec3 movement = owner.m_20184_();
        owner.m_20334_(movement.f_82479_, 0.03, movement.f_82481_);
        float f = owner.f_20900_ * 0.5f;
        float f1 = owner.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        owner.m_19920_(0.1f, new Vec3((double)f, 0.0, (double)f1));
        owner.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
            if (!owner.m_9236_().f_46443_) {
                for (double phi = 0.0; phi < Math.PI * 2; phi += 0.05) {
                    int i = 0;
                    while ((double)i < 8.0) {
                        double x = owner.m_20185_() + 8.0 * Math.cos(phi);
                        double y = owner.m_20186_() + (double)i;
                        double z = owner.m_20189_() + 8.0 * Math.sin(phi);
                        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        BlockState state = owner.m_9236_().m_8055_(pos);
                        if (state.m_60795_() && !state.m_60815_()) {
                            owner.m_9236_().m_46597_(pos, ((FakeWaterDurationBlock)((Object)((Object)JJKBlocks.FAKE_WATER_DURATION.get()))).m_49966_());
                            BlockEntity patt3067$temp = owner.m_9236_().m_7702_(pos);
                            if (patt3067$temp instanceof DurationBlockEntity) {
                                DurationBlockEntity be = (DurationBlockEntity)patt3067$temp;
                                be.create(1, state);
                            }
                        }
                        ++i;
                    }
                }
                AABB bounds = AABB.m_165882_((Vec3)owner.m_20182_(), (double)8.0, (double)8.0, (double)8.0).m_82400_(1.0);
                for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, bounds)) {
                    entity.m_20256_(entity.m_20182_().m_82546_(owner.m_20182_()).m_82541_());
                    entity.f_19864_ = true;
                }
            }
        });
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public void onStop(LivingEntity owner) {
        if (!owner.m_9236_().f_46443_) {
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0, 1.0, 0.0, 0.0, 1.0);
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0, 1.0, 0.0, 0.0, 1.0);
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (HelperMethods.RANDOM.m_188501_() - HelperMethods.RANDOM.m_188501_()) * 0.2f) * 0.7f);
            for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)owner.m_20182_(), (double)24.0, (double)24.0, (double)24.0))) {
                entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, (Ability)JJKAbilities.WATER_SHIELD.get()), 15.0f * this.getPower(owner));
            }
        }
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.WATER;
    }
}

