/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.util.HelperMethods;

public class Heal
extends Ability
implements Ability.IChannelened {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return owner.m_21223_() < owner.m_21233_();
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getEnergy() < cap.getMaxEnergy() * 0.02f) {
            return;
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            owner.m_5634_(((Double)ConfigHolder.SERVER.curseHealingAmount.get()).floatValue() * this.getPower(owner) * 0.2f + 0.5f);
        } else {
            owner.m_5634_(((Double)ConfigHolder.SERVER.curseHealingAmount.get()).floatValue() * this.getPower(owner) * 0.15f);
        }
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (int i = 0; i < 2; ++i) {
            cap.delayTickEvent(() -> {
                for (int j = 0; j < 2; ++j) {
                    double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
                    double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
                    double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
                    double speed = (double)(owner.m_20206_() * 0.1f) * HelperMethods.RANDOM.m_188500_();
                    level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.RCT, owner.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
                }
            }, i * 2);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getEnergy() < 100.0f) {
            return 0.0f;
        }
        if (owner.m_21223_() < owner.m_21233_()) {
            return ((Double)ConfigHolder.SERVER.curseHealingAmount.get()).floatValue() * this.getPower(owner) * this.getMultiplier() + 5.0f;
        }
        return 0.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.NONE;
    }

    protected float getMultiplier() {
        return 2.5f;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.CURSE && super.isValid(owner);
    }
}

