/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.ClientWrapper;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.ten_shadows.RabbitEscapeEntity;
import radon.jujutsu_kaisen.item.cursed_tool.SlaughterDemonItem;
import radon.jujutsu_kaisen.item.cursed_tool.SteelGauntletItem;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Slam
extends Ability
implements Ability.ICharged {
    private static final double RANGE = 50.0;
    private static final double LAUNCH_POWER = 2.0;
    private static final float MAX_EXPLOSION = 6.0f;
    public static Map<UUID, Float> TARGETS = new HashMap<UUID, Float>();

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        return owner.m_142582_((Entity)target);
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    private Vec3 getTarget(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(50.0)));
        return result.m_6662_() == HitResult.Type.MISS ? end : result.m_82450_();
    }

    @Override
    public void run(LivingEntity owner) {
        if (!(owner instanceof Player) || !owner.m_9236_().f_46443_) {
            return;
        }
        ClientWrapper.setOverlayMessage((Component)Component.m_237110_((String)String.format("chat.%s.charge", "jujutsu_kaisen"), (Object[])new Object[]{Math.round((float)Math.min(20, this.getCharge(owner)) / 20.0f * 100.0f)}), false);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcerer sorcerer;
        return (!(owner instanceof ISorcerer) || (sorcerer = (ISorcerer)owner).hasMeleeAttack() && sorcerer.canJump()) && super.isValid(owner);
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        if (owner.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            return Ability.Status.FAILURE;
        }
        return super.isStillUsable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 0.0f : 30.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isMelee() {
        return true;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.MELEE;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    public static void onHitGround(LivingEntity owner, float distance) {
        Slam.slamCrater(owner, distance);
    }

    public static void slamCrater(LivingEntity owner, float distance) {
        int cooldown;
        Object cap;
        if (owner.m_9236_().f_46443_) {
            return;
        }
        float radius = 6.0f;
        float dmgMult = 0.75f;
        if (JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION)) {
            dmgMult = 0.8f;
            radius = radius * 1.35f + 1.5f;
        }
        if (owner instanceof RabbitEscapeEntity) {
            radius = 1.0f;
            dmgMult = 0.3f;
        }
        boolean steeled = false;
        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
            steeled = true;
            radius = radius * 1.2f + 1.0f;
        }
        if (owner.getCapability(SorcererDataHandler.INSTANCE).isPresent() && (cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).hasToggled((Ability)JJKAbilities.RATIO_RULE.get()) && (cooldown = cap.getRemainingCooldown((Ability)JJKAbilities.RATIO_RULE.get())) <= 0) {
            dmgMult = 0.7f;
            radius *= 1.5f;
        }
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (!owner.m_9236_().f_46443_) {
            DamageSource damageSource;
            for (LivingEntity entity2 : owner.m_9236_().m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)owner.m_20182_(), (double)(radius * 2.0f), (double)(radius * 2.0f), (double)(radius * 2.0f)), entity -> entity != owner)) {
                int stunDuration = 40;
                int staggerDuration = 0;
                if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
                    stunDuration = 50;
                }
                if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SlaughterDemonItem) {
                    staggerDuration = 20;
                }
                entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), stunDuration, 0, false, false, false));
                entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), staggerDuration, 0, false, false, false));
            }
            ResourceKey resourceKey = owner.m_9236_().m_46472_();
            Vec3 vec3 = owner.m_20182_();
            float f = Ability.getPower((Ability)JJKAbilities.SLAM.get(), owner) * dmgMult;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                damageSource = owner.m_269291_().m_269075_(player);
            } else {
                damageSource = owner.m_269291_().m_269333_(owner);
            }
            ExplosionHandler.spawn((ResourceKey<Level>)resourceKey, vec3, radius, 5, f, owner, damageSource, false, true);
        }
        if (steeled) {
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_12600_, SoundSource.MASTER, 3.0f, 0.8f);
        }
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.SLAM.get(), SoundSource.MASTER, 1.0f, 1.0f);
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_276434_, SoundSource.MASTER, 2.0f, 1.0f);
        TARGETS.remove(owner.m_20148_());
    }

    @Override
    public boolean onRelease(LivingEntity owner) {
        int cooldown;
        if (owner.m_21023_((MobEffect)JJKEffects.STAGGER.get())) {
            return false;
        }
        double launchPower = 2.0 + 2.0 * (double)(Math.min(20, this.getCharge(owner)) / 20);
        float checkcharge = (float)Math.min(20, this.getCharge(owner)) / 20.0f;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (checkcharge >= 0.65f && checkcharge <= 0.75f && cap.hasToggled((Ability)JJKAbilities.RATIO_RULE.get()) && (cooldown = cap.getRemainingCooldown((Ability)JJKAbilities.RATIO_RULE.get())) <= 0) {
            launchPower = 16.0;
            cap.moreBlackFlash(true);
            System.out.println(this.getCharge(owner));
            cap.delayTickEvent(() -> cap.moreBlackFlash(false), 40);
        }
        double reallaunch = launchPower;
        if (!owner.m_20096_()) {
            if (!owner.m_9236_().f_46443_) {
                TARGETS.put(owner.m_20148_(), Float.valueOf((float)Math.min(20, this.getCharge(owner)) / 20.0f));
            }
            Vec3 target = this.getTarget(owner);
            Vec3 velocity = target.m_82546_(owner.m_20182_()).m_82541_().m_82490_(reallaunch);
            velocity = velocity.f_82480_ > 0.0 ? velocity.m_82542_(1.0, 0.0, 1.0) : velocity.m_82542_(1.2, 1.7, 1.2);
            owner.m_20256_(velocity);
            owner.m_6674_(InteractionHand.MAIN_HAND);
            cap.delayTickEvent(() -> TARGETS.remove(owner.m_20148_()), 60);
        } else if (owner.m_6144_()) {
            if (!owner.m_9236_().f_46443_) {
                TARGETS.put(owner.m_20148_(), Float.valueOf((float)Math.min(20, this.getCharge(owner)) / 20.0f));
            }
            owner.m_6674_(InteractionHand.MAIN_HAND);
            Slam.slamCrater(owner, 1.0f);
        } else {
            Vec3 direction = new Vec3(0.0, Math.min(3.0, reallaunch * 0.65), 0.0);
            owner.m_20256_(owner.m_20184_().m_82549_(direction));
            float power = (float)Math.min(20, this.getCharge(owner)) / 20.0f;
            cap.delayTickEvent(() -> {
                if (!owner.m_9236_().f_46443_) {
                    TARGETS.put(owner.m_20148_(), Float.valueOf(power));
                }
                Vec3 target = this.getTarget(owner);
                Vec3 velocity = target.m_82546_(owner.m_20182_()).m_82541_().m_82490_(reallaunch);
                velocity = velocity.f_82480_ > 0.0 ? velocity.m_82542_(1.0, 0.0, 1.0) : velocity.m_82542_(1.0, 2.0, 1.0);
                owner.m_20256_(velocity);
                cap.delayTickEvent(() -> TARGETS.remove(owner.m_20148_()), 60);
            }, 15);
        }
        return true;
    }
}

