/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.mythical_beast_amber;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedSpeechParticle;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class EMFBlast
extends Ability {
    private static final double RANGE = 30.0;
    private static final double RADIUS = 2.5;
    private static final float DAMAGE = 20.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return EMFBlast.getEntities((LivingEntity)owner).contains(target) && HelperMethods.RANDOM.m_188503_(5) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.MYTHICAL_BEAST_AMBER.get()) && super.isValid(owner);
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        return JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.MYTHICAL_BEAST_AMBER.get()) && super.isDisplayed(owner);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static List<Entity> getEntities(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(30.0)).m_82400_(2.5);
        return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
            LivingEntity living;
            return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
        });
    }

    private void spawnParticles(Entity entity, LivingEntity owner) {
        double x = entity.m_20185_();
        double y = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f);
        double z = entity.m_20189_();
        for (int i = 0; i < 50; ++i) {
            double scale = HelperMethods.RANDOM.m_188500_() * 0.95 + 0.95;
            Vec3 speed = new Vec3(HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_()).m_82541_().m_82490_(scale);
            double offsetX = x + speed.f_82479_;
            double offsetY = y + speed.f_82480_;
            double offsetZ = z + speed.f_82481_;
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 2), offsetX, offsetY, offsetZ, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        int i = 1;
        while ((double)i < 37.0) {
            Vec3 dst = src.m_82549_(look.m_82490_((double)i));
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new CursedSpeechParticle.CursedSpeechParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), (float)(src.m_82554_(dst) * 0.5)), dst.f_82479_, dst.f_82480_, dst.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.SPARK.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        for (Entity entity : EMFBlast.getEntities(owner)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || JJKAbilities.hasToggled(living = (LivingEntity)entity, (Ability)JJKAbilities.INFINITY.get())) continue;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.delayTickEvent(() -> {
                if (entity != null && entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 20.0f * this.getPower(owner))) {
                    Vec3 center = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 3), center.f_82479_, center.f_82480_, center.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
                    owner.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (HelperMethods.RANDOM.m_188501_() - HelperMethods.RANDOM.m_188501_()) * 0.2f) * 0.7f);
                    owner.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_12089_, SoundSource.BLOCKS, 4.0f, (1.0f + (HelperMethods.RANDOM.m_188501_() - HelperMethods.RANDOM.m_188501_()) * 0.2f) * 0.7f);
                    float radius = 5.0f;
                    int minX = Mth.m_14107_((double)(entity.m_20185_() - (double)radius - 1.0));
                    int maxX = Mth.m_14107_((double)(entity.m_20185_() + (double)radius + 1.0));
                    int minY = Mth.m_14107_((double)(entity.m_20186_() - (double)radius - 1.0));
                    int maxY = Mth.m_14107_((double)(entity.m_20186_() + (double)radius + 1.0));
                    int minZ = Mth.m_14107_((double)(entity.m_20189_() - (double)radius - 1.0));
                    int maxZ = Mth.m_14107_((double)(entity.m_20189_() + (double)radius + 1.0));
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                double distance = ((double)x - entity.m_20185_()) * ((double)x - entity.m_20185_()) + ((double)y - entity.m_20186_()) * ((double)y - entity.m_20186_()) + ((double)z - entity.m_20189_()) * ((double)z - entity.m_20189_());
                                if (!(distance <= (double)(radius * radius))) continue;
                                BlockPos pos = new BlockPos(x, y, z);
                                if (!HelperMethods.isDestroyable((BlockGetter)owner.m_9236_(), owner, pos)) continue;
                                owner.m_9236_().m_46961_(pos, false);
                            }
                        }
                    }
                    this.spawnParticles(entity, owner);
                    entity.f_19864_ = true;
                    living.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 30, 0, false, false, false));
                }
            }, 10);
        }
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 150.0f;
    }

    @Override
    public int getCooldown() {
        return 320;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.CURSED_SPEECH;
    }
}

