/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ratio;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.EmittingLightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Collapse
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final int RANGE = 10;
    private static final int DELAY = 20;
    private static final float DAMAGE = 10.0f;
    private static final int DURATION = 25;
    private static final float RADIUS = 3.0f;
    private static final float EXPLOSIVE_POWER = 3.0f;
    private static final float MAX_EXPLOSIVE_POWER = 10.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || !owner.m_142582_((Entity)target)) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(5) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(3) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Vec3 pos = owner.m_20182_();
        int index = this.getCharge(owner);
        float scale = 1.5f;
        int i = 0;
        while ((float)i < 12.0f * scale) {
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.5f * scale) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            double speed = (double)(owner.m_20206_() * 0.3f) * HelperMethods.RANDOM.m_188500_();
            level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.FALLING_BLOSSOM_EMOTION, owner.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
            ++i;
        }
        if (index == 15 && owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.COLLAPSE.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    public void onStop(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 start = owner.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 end = start.m_82549_(look.m_82490_(10.0));
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            int index = this.getCharge(owner);
            owner.m_6674_(InteractionHand.MAIN_HAND);
            for (int i = 0; i < 12; ++i) {
                level2.m_8767_((ParticleOptions)new EmittingLightningParticle.EmittingLightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 6.0f, 1), owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            Vec3 realpos = result.m_82450_();
            if (index >= 20 && index < 25) {
                ExplosionHandler.spawn((ResourceKey<Level>)owner.m_9236_().m_46472_(), realpos, Math.min(11.0f, 3.0f * this.getPower(owner) * 1.1f), 20, 10.0f + this.getPower(owner) * 0.1f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)owner, owner, (Ability)JJKAbilities.COLLAPSE.get()), false);
                BlockHitResult hit = this.getBlockHit(owner, 10.0);
                BlockPos blocked = hit.m_82425_();
                AABB bounds = new AABB((double)((float)blocked.m_123341_() * 0.9f), (double)((float)blocked.m_123342_() * 0.9f), (double)((float)blocked.m_123343_() * 0.9f), (double)((float)blocked.m_123341_() * 1.05f), (double)((float)blocked.m_123342_() * 1.05f), (double)((float)blocked.m_123343_() * 1.05f));
                double centerX = bounds.m_82399_().f_82479_;
                double centerY = bounds.m_82399_().f_82480_;
                double centerZ = bounds.m_82399_().f_82481_;
                int x = (int)bounds.f_82288_;
                while ((double)x <= bounds.f_82291_) {
                    int y = (int)bounds.f_82289_;
                    while ((double)y <= bounds.f_82292_) {
                        int z = (int)bounds.f_82290_;
                        while ((double)z <= bounds.f_82293_) {
                            BlockPos blocker = new BlockPos(x, y, z);
                            BlockState state = owner.m_9236_().m_8055_(blocker);
                            double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                            if (distance <= 3.0 && HelperMethods.isDestroyable((BlockGetter)owner.m_9236_(), owner, blocker) && owner.m_9236_().m_46961_(blocker, false)) {
                                FallingBlockEntity entity = FallingBlockEntity.m_201971_((Level)owner.m_9236_(), (BlockPos)blocker, (BlockState)state);
                                entity.f_19794_ = true;
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            } else if (index < 25 || index >= 25) {
                ExplosionHandler.spawn((ResourceKey<Level>)owner.m_9236_().m_46472_(), realpos, Math.min(7.5f, 3.0f * this.getPower(owner) * 0.75f), 20, 10.0f + this.getPower(owner) * 0.1f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)owner, owner, (Ability)JJKAbilities.COLLAPSE.get()), false);
            }
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 13.0f;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public int getDuration() {
        return 5;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

