/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.capability.data.ten_shadows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.Adaptation;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsMode;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.WheelEntity;

public class TenShadowsData
implements ITenShadowsData {
    private final Set<ResourceLocation> tamed;
    private final Set<ResourceLocation> dead;
    private final List<ItemStack> shadowInventory;
    private final Set<Adaptation> adapted;
    private final Map<Adaptation, Integer> adapting;
    private TenShadowsMode mode = TenShadowsMode.SUMMON;
    private LivingEntity owner;

    public TenShadowsData() {
        this.tamed = new HashSet<ResourceLocation>();
        this.dead = new HashSet<ResourceLocation>();
        this.adapted = new HashSet<Adaptation>();
        this.adapting = new HashMap<Adaptation, Integer>();
        this.shadowInventory = new ArrayList<ItemStack>();
    }

    private void updateAdaptation() {
        ISorcererData cap = (ISorcererData)this.owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!cap.hasToggled((Ability)JJKAbilities.WHEEL.get())) {
            return;
        }
        Iterator<Map.Entry<Adaptation, Integer>> iter = this.adapting.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Adaptation, Integer> entry = iter.next();
            int timer = entry.getValue();
            if (++timer >= 1600) {
                WheelEntity wheel;
                iter.remove();
                this.adapted.add(entry.getKey());
                LivingEntity livingEntity = this.owner;
                if (livingEntity instanceof MahoragaEntity) {
                    MahoragaEntity mahoraga = (MahoragaEntity)livingEntity;
                    mahoraga.onAdaptation();
                }
                if ((wheel = cap.getSummonByClass(WheelEntity.class)) == null) continue;
                wheel.spin();
                continue;
            }
            entry.setValue(timer);
        }
    }

    @Override
    public void tick(LivingEntity owner) {
        if (this.owner == null) {
            this.owner = owner;
        }
        if (!this.owner.m_9236_().f_46443_) {
            this.updateAdaptation();
        }
    }

    @Override
    public void init(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasTamed(Registry<EntityType<?>> registry, EntityType<?> entity) {
        return this.tamed.contains(registry.m_7981_(entity));
    }

    @Override
    public void tame(Registry<EntityType<?>> registry, EntityType<?> entity) {
        this.tamed.add(registry.m_7981_(entity));
    }

    @Override
    public void setTamed(Set<ResourceLocation> tamed) {
        this.tamed.clear();
        this.tamed.addAll(tamed);
    }

    @Override
    public Set<ResourceLocation> getTamed() {
        return this.tamed;
    }

    @Override
    public boolean isDead(Registry<EntityType<?>> registry, EntityType<?> entity) {
        return this.dead.contains(registry.m_7981_(entity));
    }

    @Override
    public Set<ResourceLocation> getDead() {
        return this.dead;
    }

    @Override
    public void setDead(Set<ResourceLocation> dead) {
        this.dead.clear();
        this.dead.addAll(dead);
    }

    @Override
    public void kill(Registry<EntityType<?>> registry, EntityType<?> entity) {
        this.dead.add(registry.m_7981_(entity));
    }

    @Override
    public void revive(boolean full) {
        this.dead.clear();
        if (full) {
            this.tamed.clear();
        }
    }

    @Override
    public Set<Adaptation> getAdapted() {
        return this.adapted;
    }

    @Override
    public void addAdapted(Set<Adaptation> adaptations) {
        this.adapted.addAll(adaptations);
    }

    @Override
    public Map<Adaptation, Integer> getAdapting() {
        return this.adapting;
    }

    @Override
    public void addAdapting(Map<Adaptation, Integer> adapting) {
        this.adapting.putAll(adapting);
    }

    @Override
    public void addShadowInventory(ItemStack stack) {
        this.shadowInventory.add(stack);
    }

    @Override
    public ItemStack getShadowInventory(int index) {
        return this.shadowInventory.get(index);
    }

    @Override
    public List<ItemStack> getShadowInventory() {
        return this.shadowInventory;
    }

    @Override
    public void removeShadowInventory(int index) {
        this.shadowInventory.remove(index);
    }

    private Adaptation getAdaptation(DamageSource source) {
        Ability ability;
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        ResourceLocation resourceLocation = types.m_7981_((Object)source.m_269415_());
        if (source instanceof JJKDamageSources.JujutsuDamageSource) {
            JJKDamageSources.JujutsuDamageSource jujutsu = (JJKDamageSources.JujutsuDamageSource)source;
            ability = jujutsu.getAbility();
        } else {
            ability = null;
        }
        return new Adaptation(resourceLocation, ability);
    }

    @Override
    public float getAdaptationProgress(DamageSource source) {
        return this.getAdaptationProgress(this.getAdaptation(source));
    }

    @Override
    public float getAdaptationProgress(Adaptation adaptation) {
        return this.adapted.contains(adaptation) ? 1.0f : (float)this.adapting.getOrDefault(adaptation, 0).intValue() / 1600.0f;
    }

    @Override
    public Adaptation.Type getAdaptationType(DamageSource source) {
        Adaptation adaptation = this.getAdaptation(source);
        return this.getAdaptationType(adaptation);
    }

    @Override
    public Adaptation.Type getAdaptationType(Adaptation adaptation) {
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        DamageType type = (DamageType)types.m_7745_(adaptation.getKey());
        if (type == types.m_6246_(DamageTypes.f_268566_) || type == types.m_6246_(DamageTypes.f_268464_)) {
            return Adaptation.Type.COUNTER;
        }
        return Adaptation.Type.DAMAGE;
    }

    @Override
    public Map<Adaptation.Type, Float> getAdaptationTypes() {
        HashMap<Adaptation.Type, Float> adaptations = new HashMap<Adaptation.Type, Float>();
        for (Adaptation adaptation : this.adapting.keySet()) {
            adaptations.put(this.getAdaptationType(adaptation), Float.valueOf(this.getAdaptationProgress(adaptation)));
        }
        for (Adaptation adaptation : this.adapted) {
            adaptations.put(this.getAdaptationType(adaptation), Float.valueOf(this.getAdaptationProgress(adaptation)));
        }
        return adaptations;
    }

    @Override
    public boolean isAdaptedTo(DamageSource source) {
        Adaptation adaptation = this.getAdaptation(source);
        return this.adapted.contains(adaptation);
    }

    @Override
    public boolean isAdaptedTo(Ability ability) {
        for (Adaptation adapted : this.adapted) {
            Ability current = adapted.getAbility();
            if (current == null) continue;
            if (current == ability) {
                return true;
            }
            Ability.Classification first = current.getClassification();
            Ability.Classification second = ability.getClassification();
            if (first == Ability.Classification.NONE || second == Ability.Classification.NONE || first != second) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAdaptedTo(CursedTechnique technique) {
        for (Ability ability : technique.getAbilities()) {
            if (!this.isAdaptedTo(ability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tryAdapt(DamageSource source) {
        Ability ability;
        RegistryAccess registry = this.owner.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        ResourceLocation resourceLocation = types.m_7981_((Object)source.m_269415_());
        if (source instanceof JJKDamageSources.JujutsuDamageSource) {
            JJKDamageSources.JujutsuDamageSource jujutsu = (JJKDamageSources.JujutsuDamageSource)source;
            ability = jujutsu.getAbility();
        } else {
            ability = null;
        }
        Adaptation adaptation = new Adaptation(resourceLocation, ability);
        if (!this.adapting.containsKey(adaptation)) {
            this.adapting.put(adaptation, 0);
        } else {
            int timer = this.adapting.get(adaptation);
            this.adapting.put(adaptation, timer += 100);
        }
    }

    @Override
    public void tryAdapt(Ability ability) {
        Adaptation adaptation = new Adaptation(JJKDamageSources.JUJUTSU.m_135782_(), ability);
        if (!this.adapting.containsKey(adaptation)) {
            this.adapting.put(adaptation, 0);
        } else {
            int timer = this.adapting.get(adaptation);
            this.adapting.put(adaptation, timer += 100);
        }
    }

    @Override
    public TenShadowsMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TenShadowsMode mode) {
        this.mode = mode;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("mode", this.mode.ordinal());
        ListTag tamedTag = new ListTag();
        for (ResourceLocation resourceLocation : this.tamed) {
            tamedTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("tamed", (Tag)tamedTag);
        ListTag deadTag = new ListTag();
        for (ResourceLocation resourceLocation : this.dead) {
            deadTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("dead", (Tag)deadTag);
        ListTag listTag = new ListTag();
        for (Adaptation adaptation : this.adapted) {
            listTag.add((Object)adaptation.serializeNBT());
        }
        nbt.m_128365_("adapted", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry<Adaptation, Integer> entry : this.adapting.entrySet()) {
            CompoundTag data = new CompoundTag();
            data.m_128365_("adaptation", (Tag)entry.getKey().serializeNBT());
            data.m_128405_("stage", entry.getValue().intValue());
            listTag2.add((Object)data);
        }
        nbt.m_128365_("adapting", (Tag)listTag2);
        ListTag listTag3 = new ListTag();
        for (ItemStack stack : this.shadowInventory) {
            listTag3.add((Object)stack.m_41739_(new CompoundTag()));
        }
        nbt.m_128365_("shadow_inventory", (Tag)listTag3);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.mode = TenShadowsMode.values()[nbt.m_128451_("mode")];
        this.tamed.clear();
        for (Tag key : nbt.m_128437_("tamed", 8)) {
            this.tamed.add(new ResourceLocation(key.m_7916_()));
        }
        this.dead.clear();
        for (Tag key : nbt.m_128437_("dead", 8)) {
            this.dead.add(new ResourceLocation(key.m_7916_()));
        }
        this.adapted.clear();
        for (Tag key : nbt.m_128437_("adapted", 10)) {
            this.adapted.add(new Adaptation((CompoundTag)key));
        }
        this.adapting.clear();
        for (Tag key : nbt.m_128437_("adapting", 10)) {
            CompoundTag adaptation = (CompoundTag)key;
            this.adapting.put(new Adaptation(adaptation.m_128469_("adaptation")), adaptation.m_128451_("stage"));
        }
        this.shadowInventory.clear();
        for (Tag key : nbt.m_128437_("shadow_inventory", 10)) {
            this.shadowInventory.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)key)));
        }
    }
}

