/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.client.gui.screen.tab.AbilityTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.BindingVowTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.ChantTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.CursedEnergyColorTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.DomainCustomizationTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.tab.PactTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.StatsTab;

public class JujutsuScreen
extends Screen {
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("textures/gui/advancements/window.png");
    public static final ResourceLocation TABS_LOCATION = new ResourceLocation("textures/gui/advancements/tabs.png");
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 140;
    private static final int WINDOW_INSIDE_X = 9;
    private static final int WINDOW_INSIDE_Y = 18;
    public static final int WINDOW_INSIDE_WIDTH = 234;
    public static final int WINDOW_INSIDE_HEIGHT = 113;
    public static final int BACKGROUND_TILE_WIDTH = 16;
    public static final int BACKGROUND_TILE_HEIGHT = 16;
    private final List<JJKTab> tabs = new ArrayList<JJKTab>();
    @Nullable
    private JJKTab selectedTab;
    private static int tabPage;
    private static int maxPages;
    private boolean isScrolling;

    public JujutsuScreen() {
        super(GameNarrator.f_93310_);
    }

    private void setSelectedTab(@NotNull JJKTab tab) {
        if (this.selectedTab != null) {
            for (GuiEventListener widget : this.selectedTab.getRenderables()) {
                this.m_169411_(widget);
            }
            this.selectedTab.removeWidgets();
        }
        this.selectedTab = tab;
        this.selectedTab.addWidgets();
    }

    public void removeWidgets() {
        if (this.selectedTab != null) {
            for (GuiEventListener widget : this.selectedTab.getRenderables()) {
                this.m_169411_(widget);
            }
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.selectedTab != null) {
            this.selectedTab.tick();
        }
    }

    @NotNull
    public <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T pWidget) {
        return (T)super.m_142416_(pWidget);
    }

    protected void m_7856_() {
        this.tabs.clear();
        this.selectedTab = null;
        int index = 0;
        this.tabs.add(new StatsTab(this.f_96541_, this, JJKTabType.ABOVE, 0, 0));
        this.tabs.add(new DomainCustomizationTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.tabs.add(new PactTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.tabs.add(new BindingVowTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.tabs.add(new AbilityTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.tabs.add(new ChantTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.tabs.add(new CursedEnergyColorTab(this.f_96541_, this, JJKTabType.ABOVE, ++index % JJKTabType.MAX_TABS, index / JJKTabType.MAX_TABS));
        this.setSelectedTab(this.tabs.get(0));
        if (this.tabs.size() > JJKTabType.MAX_TABS) {
            int guiLeft = (this.f_96543_ - 252) / 2;
            int guiTop = (this.f_96544_ - 140) / 2;
            this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252794_(guiLeft, guiTop - 50).m_253046_(20, 20).m_253136_());
            this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252794_(guiLeft + 252 - 20, guiTop - 50).m_253046_(20, 20).m_253136_());
            maxPages = this.tabs.size() / JJKTabType.MAX_TABS;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int j;
        int i;
        if (this.selectedTab != null) {
            i = (this.f_96543_ - 252) / 2;
            j = (this.f_96544_ - 140) / 2;
            this.selectedTab.mouseClicked(pMouseX - (double)i - 9.0, pMouseY - (double)j - 18.0, pButton);
        }
        if (pButton == 0) {
            i = (this.f_96543_ - 252) / 2;
            j = (this.f_96544_ - 140) / 2;
            for (JJKTab tab : this.tabs) {
                if (tab.getPage() != tabPage || !tab.isMouseOver(i, j, pMouseX, pMouseY)) continue;
                this.setSelectedTab(tab);
                break;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selectedTab != null) {
            this.selectedTab.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i = (this.f_96543_ - 252) / 2;
        int j = (this.f_96544_ - 140) / 2;
        this.m_280273_(pGuiGraphics);
        if (maxPages != 0) {
            MutableComponent page = Component.m_237113_((String)String.format("%d / %d", tabPage + 1, maxPages + 1));
            int width = this.f_96547_.m_92852_((FormattedText)page);
            pGuiGraphics.m_280648_(this.f_96547_, page.m_7532_(), i + 126 - width / 2, j - 44, -1);
        }
        this.renderInside(pGuiGraphics, pMouseX, pMouseY, i, j);
        this.renderWindow(pGuiGraphics, i, j);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, i, j);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private void renderInside(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pOffsetX, int pOffsetY) {
        if (this.selectedTab != null) {
            this.selectedTab.drawContents(pGuiGraphics, pOffsetX + 9, pOffsetY + 18);
        }
    }

    public void renderWindow(GuiGraphics pGuiGraphics, int pOffsetX, int pOffsetY) {
        RenderSystem.enableBlend();
        pGuiGraphics.m_280218_(WINDOW_LOCATION, pOffsetX, pOffsetY, 0, 0, 252, 140);
        for (JJKTab tab : this.tabs) {
            if (tab.getPage() != tabPage) continue;
            tab.drawTab(pGuiGraphics, pOffsetX, pOffsetY, tab == this.selectedTab);
        }
        for (JJKTab tab : this.tabs) {
            if (tab.getPage() != tabPage) continue;
            tab.drawIcon(pGuiGraphics, pOffsetX, pOffsetY);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pOffsetX, int pOffsetY) {
        if (this.selectedTab != null) {
            this.selectedTab.drawTooltips(pGuiGraphics, pMouseX, pMouseY, pOffsetX, pOffsetY);
        }
        for (JJKTab JJKTab2 : this.tabs) {
            if (JJKTab2.getPage() != tabPage || !JJKTab2.isMouseOver(pOffsetX, pOffsetY, pMouseX, pMouseY)) continue;
            pGuiGraphics.m_280557_(this.f_96547_, JJKTab2.getTitle(), pMouseX, pMouseY);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(pDragX, pDragY);
        }
        return true;
    }
}

