/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.RegistryObject;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.widget.AbilityWidget;

public class AbilityTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.ability", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private final Map<Ability, AbilityWidget> abilities = new HashMap<Ability, AbilityWidget>();
    private final List<AbilityWidget> roots = new ArrayList<AbilityWidget>();
    private float fade;

    public AbilityTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42584_.m_7968_(), TITLE, BACKGROUND, true);
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        for (RegistryObject entry : JJKAbilities.ABILITIES.getEntries()) {
            Ability ability = (Ability)entry.get();
            if (!ability.isDisplayed((LivingEntity)this.minecraft.f_91074_) || ability.getParent((LivingEntity)this.minecraft.f_91074_) != null) continue;
            this.addAbilityAndChildren(ability);
        }
    }

    private void addAbilityAndChildren(Ability ability) {
        this.addAbility(ability);
        for (RegistryObject entry : JJKAbilities.ABILITIES.getEntries()) {
            Ability current = (Ability)entry.get();
            if (!current.isDisplayed((LivingEntity)this.minecraft.f_91074_) || current.getParent((LivingEntity)this.minecraft.f_91074_) != ability) continue;
            this.addAbilityAndChildren(current);
        }
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237110_((String)String.format("gui.%s.ability.points", "jujutsu_kaisen"), (Object[])new Object[]{cap.getPoints()}), xOffset, yOffset, 0xFFFFFF, true);
    }

    @Override
    protected void drawCustom(GuiGraphics graphics, int x, int y) {
        for (AbilityWidget root : this.roots) {
            root.drawConnectivity(graphics, x, y, true);
            root.drawConnectivity(graphics, x, y, false);
            root.draw(graphics, x, y);
        }
    }

    @Nullable
    public AbilityWidget getAbility(Ability ability) {
        return this.abilities.get(ability);
    }

    @Override
    public void drawTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pOffsetX, int pOffsetY) {
        super.drawTooltips(pGuiGraphics, pMouseX, pMouseY, pOffsetX, pOffsetY);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)(pOffsetX + 9), (float)(pOffsetY + 18), 400.0f);
        RenderSystem.enableDepthTest();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85837_(0.0, 0.0, -200.0);
        pGuiGraphics.m_280509_(0, 0, 234, 113, Mth.m_14143_((float)(this.fade * 255.0f)) << 24);
        boolean hovered = false;
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        if (pMouseX - pOffsetX - 9 > 0 && pMouseX - pOffsetX - 9 < 234 && pMouseY - pOffsetY - 18 > 0 && pMouseY - pOffsetY - 18 < 113) {
            for (AbilityWidget widget : this.abilities.values()) {
                if (!widget.isMouseOver(i, j, pMouseX - pOffsetX - 9, pMouseY - pOffsetY - 18)) continue;
                hovered = true;
                widget.drawHover(pGuiGraphics, i, j, this.fade, pOffsetX, pOffsetY);
                break;
            }
        }
        pGuiGraphics.m_280168_().m_85849_();
        this.fade = hovered ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        pGuiGraphics.m_280168_().m_85849_();
    }

    public void addAbility(Ability ability) {
        AbilityWidget widget = new AbilityWidget(this, this.minecraft, ability);
        if (ability.getParent((LivingEntity)this.minecraft.f_91074_) == null) {
            this.roots.add(widget);
        }
        this.abilities.put(ability, widget);
        int i = widget.getX();
        int j = i + 28;
        int k = widget.getY();
        int l = k + 27;
        this.minX = Math.min(this.minX, i);
        this.maxX = Math.max(this.maxX, j);
        this.minY = Math.min(this.minY, k);
        this.maxY = Math.max(this.maxY, l);
        for (AbilityWidget child : this.abilities.values()) {
            child.attachToParent();
        }
    }

    @Override
    public void addWidgets() {
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        if (pMouseX > 0.0 && pMouseX < 234.0 && pMouseY > 0.0 && pMouseY < 113.0) {
            for (AbilityWidget widget : this.abilities.values()) {
                if (!widget.isMouseOver(i, j, (int)pMouseX, (int)pMouseY)) continue;
                widget.unlock();
                break;
            }
        }
    }
}

