/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.widget.AbilityListWidget;
import radon.jujutsu_kaisen.client.gui.screen.widget.ChantListWidget;
import radon.jujutsu_kaisen.client.gui.screen.widget.JJKSelectionList;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.AddChantC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.RemoveChantC2SPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ChantTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.chant", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private ChantListWidget chants;
    private EditBox text;
    private Button add;
    private Button remove;
    @Nullable
    private AbilityListWidget.Entry ability;
    @Nullable
    private ChantListWidget.Entry chant;

    public ChantTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42690_.m_7968_(), TITLE, BACKGROUND, false);
    }

    public void setSelectedAbility(AbilityListWidget.Entry entry) {
        this.ability = entry;
        this.chants.refreshList();
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildAbilityList(Consumer<T> consumer, Function<Ability, T> result) {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        List<Ability> abilities = JJKAbilities.getAbilities((LivingEntity)this.minecraft.f_91074_);
        for (Ability ability : abilities) {
            if (!ability.isScalable((LivingEntity)this.minecraft.f_91074_) || !ability.isTechnique()) continue;
            consumer.accept((ObjectSelectionList.Entry)result.apply(ability));
        }
    }

    public void setSelectedChant(ChantListWidget.Entry entry) {
        this.chant = entry;
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildChantList(Consumer<T> consumer, Function<String, T> result) {
        if (this.ability == null || this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.getFirstChants(this.ability.get()).forEach(chant -> consumer.accept((ObjectSelectionList.Entry)result.apply((String)chant)));
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.chant.techniques", "jujutsu_kaisen")), xOffset, yOffset, 0xFFFFFF, true);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.chant.chants", "jujutsu_kaisen")), xOffset + 77, yOffset, 0xFFFFFF, true);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.chant.chant", "jujutsu_kaisen")), xOffset + 154, yOffset, 0xFFFFFF, true);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        String text = this.text.m_94155_().toLowerCase();
        boolean unique = true;
        if (!text.isEmpty() && !text.isBlank()) {
            for (ChantListWidget.Entry chant : this.chants.m_6702_()) {
                if (!((double)HelperMethods.strcmp(chant.get(), text) < (Double)ConfigHolder.SERVER.chantSimilarityThreshold.get())) continue;
                unique = false;
                break;
            }
        }
        this.add.f_93623_ = unique && this.chants.m_6702_().size() < (Integer)ConfigHolder.SERVER.maximumChantCount.get() && !text.isEmpty() && !text.isBlank() && this.ability != null && !cap.hasChant(this.ability.get(), text);
        this.remove.f_93623_ = this.ability != null && this.chant != null;
    }

    @Override
    public void addWidgets() {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        JJKSelectionList.IBuilder<Ability, AbilityListWidget.Entry> iBuilder = this::buildAbilityList;
        JJKSelectionList.ICallback<AbilityListWidget.Entry> iCallback = this::setSelectedAbility;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.addRenderableWidget(new AbilityListWidget(iBuilder, iCallback, this.minecraft, 67, 85, xOffset, yOffset + 9 + 1));
        JJKSelectionList.IBuilder<String, ChantListWidget.Entry> iBuilder2 = this::buildChantList;
        JJKSelectionList.ICallback<ChantListWidget.Entry> iCallback2 = this::setSelectedChant;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.chants = new ChantListWidget(iBuilder2, iCallback2, this.minecraft, 67, 85, xOffset + 77, yOffset + 9 + 1);
        this.addRenderableWidget(this.chants);
        Font font = this.minecraft.f_91062_;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.text = new EditBox(font, xOffset + 154, yOffset + 9 + 2, 62, 20, (Component)Component.m_237119_());
        this.text.m_94199_(((Integer)ConfigHolder.SERVER.maximumChantLength.get()).intValue());
        this.addRenderableWidget(this.text);
        Button.Builder builder = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.chant.add", "jujutsu_kaisen")), pButton -> {
            String text = this.text.m_94155_();
            if (this.ability == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            PacketHandler.sendToServer(new AddChantC2SPacket(JJKAbilities.getKey(this.ability.get()), text));
            cap.addChant(this.ability.get(), text);
            this.chants.refreshList();
        }).m_253046_(62, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.add = builder.m_252794_(xOffset + 154, yOffset + 9 + 40).m_253136_();
        this.addRenderableWidget(this.add);
        Button.Builder builder2 = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.chant.remove", "jujutsu_kaisen")), pButton -> {
            if (this.ability == null || this.chant == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            PacketHandler.sendToServer(new RemoveChantC2SPacket(JJKAbilities.getKey(this.ability.get()), this.chant.get()));
            cap.removeChant(this.ability.get(), this.chant.get());
            this.chants.refreshList();
        }).m_253046_(62, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.remove = builder2.m_252794_(xOffset + 154, yOffset + 9 + 66).m_253136_();
        this.addRenderableWidget(this.remove);
    }

    @Override
    public void keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.add.f_93623_ && pKeyCode == 257) {
            this.add.m_5691_();
        } else if (this.remove.f_93623_ && pKeyCode == 261) {
            this.remove.m_5691_();
        }
    }
}

