/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.particle.JJKParticleRenderTypes;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class CursedSpeechParticle
extends HugeExplosionParticle {
    protected CursedSpeechParticle(ClientLevel level, double x, double y, double z, CursedSpeechParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, 1.0, sprites);
        this.f_107225_ = 16;
        this.f_107663_ = options.scalar();
        Vector3f color = options.color();
        this.f_107227_ = color.x;
        this.f_107228_ = color.y;
        this.f_107229_ = color.z;
        this.m_108339_(sprites);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return JJKParticleRenderTypes.ADDITIVE;
    }

    public int m_6355_(float pPartialTick) {
        float f = ((float)this.f_107224_ + pPartialTick) / (float)this.f_107225_;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(pPartialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public record CursedSpeechParticleOptions(Vector3f color, float scalar) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<CursedSpeechParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<CursedSpeechParticleOptions>(){

            @NotNull
            public CursedSpeechParticleOptions fromCommand(@NotNull ParticleType<CursedSpeechParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                Vector3f color = CursedSpeechParticleOptions.readColorVector3f(reader);
                reader.expect(' ');
                return new CursedSpeechParticleOptions(color, reader.readFloat());
            }

            @NotNull
            public CursedSpeechParticleOptions fromNetwork(@NotNull ParticleType<CursedSpeechParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new CursedSpeechParticleOptions(CursedSpeechParticleOptions.readColorFromNetwork(buf), buf.readFloat());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.CURSED_SPEECH.get();
        }

        public static Vector3f readColorVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f0 = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new Vector3f(f0, f1, f2);
        }

        public static Vector3f readColorFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeFloat(this.color.x);
            buf.writeFloat(this.color.y);
            buf.writeFloat(this.color.z);
            buf.writeFloat(this.scalar);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x), Float.valueOf(this.color.y), Float.valueOf(this.color.z), Float.valueOf(this.scalar));
        }
    }

    public static class Provider
    implements ParticleProvider<CursedSpeechParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public CursedSpeechParticle createParticle(@NotNull CursedSpeechParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CursedSpeechParticle(level, x, y, z, options, this.sprites);
        }
    }
}

