/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import radon.jujutsu_kaisen.client.FakeEntityRenderer;
import radon.jujutsu_kaisen.client.VertexCapturer;
import radon.jujutsu_kaisen.client.slice.ConvexMeshCollider;
import radon.jujutsu_kaisen.client.slice.RigidBody;

public class CutModelUtil {
    private static RigidBody.VertexData compress(RigidBody.Triangle[] triangles) {
        ArrayList<Vec3> vertices = new ArrayList<Vec3>(triangles.length * 3);
        int[] indices = new int[triangles.length * 3];
        float[] uv = new float[triangles.length * 6];
        int[] color = new int[triangles.length * 3];
        for (int i = 0; i < triangles.length; ++i) {
            RigidBody.Triangle triangle = triangles[i];
            double eps = 1.0E-5;
            int idx = CutModelUtil.epsIndexOf(vertices, triangle.p1.pos, eps);
            if (idx != -1) {
                indices[i * 3] = idx;
            } else {
                indices[i * 3] = vertices.size();
                vertices.add(triangle.p1.pos);
            }
            idx = CutModelUtil.epsIndexOf(vertices, triangle.p2.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 1] = idx;
            } else {
                indices[i * 3 + 1] = vertices.size();
                vertices.add(triangle.p2.pos);
            }
            idx = CutModelUtil.epsIndexOf(vertices, triangle.p3.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 2] = idx;
            } else {
                indices[i * 3 + 2] = vertices.size();
                vertices.add(triangle.p3.pos);
            }
            uv[i * 6] = triangle.p1.u;
            uv[i * 6 + 1] = triangle.p1.v;
            uv[i * 6 + 2] = triangle.p2.u;
            uv[i * 6 + 3] = triangle.p2.v;
            uv[i * 6 + 4] = triangle.p3.u;
            uv[i * 6 + 5] = triangle.p3.v;
            color[i * 3] = triangle.p1.color;
            color[i * 3 + 1] = triangle.p2.color;
            color[i * 3 + 2] = triangle.p3.color;
        }
        RigidBody.VertexData data = new RigidBody.VertexData();
        data.positions = vertices.toArray(new Vec3[0]);
        data.indices = indices;
        data.uv = uv;
        data.color = color;
        return data;
    }

    private static boolean epsilonEquals(Vec3 a, Vec3 b, double eps) {
        double dx = Math.abs(a.f_82479_ - b.f_82479_);
        double dy = Math.abs(a.f_82480_ - b.f_82480_);
        double dz = Math.abs(a.f_82481_ - b.f_82481_);
        return dx < eps && dy < eps && dz < eps;
    }

    private static int epsIndexOf(List<Vec3> l, Vec3 vec, double eps) {
        for (int i = 0; i < l.size(); ++i) {
            if (!CutModelUtil.epsilonEquals(vec, l.get(i), eps)) continue;
            return i;
        }
        return -1;
    }

    private static double rayPlaneIntercept(Vec3 start, Vec3 ray, float[] plane) {
        double num = -((double)plane[0] * start.f_82479_ + (double)plane[1] * start.f_82480_ + (double)plane[2] * start.f_82481_ + (double)plane[3]);
        double denom = (double)plane[0] * ray.f_82479_ + (double)plane[1] * ray.f_82480_ + (double)plane[2] * ray.f_82481_;
        return num / denom;
    }

    private static Matrix3f eulerToMat(float yaw, float pitch, float roll) {
        Matrix3f mY = new Matrix3f();
        mY.rotateY(-yaw);
        Matrix3f mP = new Matrix3f();
        mP.rotateX(pitch);
        Matrix3f mR = new Matrix3f();
        mR.rotateZ(roll);
        mR.mul((Matrix3fc)mP);
        mR.mul((Matrix3fc)mY);
        return mR;
    }

    private static Vec3 getEulerAngles(Vec3 vec) {
        double yaw = Math.toDegrees(Math.atan2(vec.f_82479_, vec.f_82481_));
        double sqrt = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
        double pitch = Math.toDegrees(Math.atan2(vec.f_82480_, sqrt));
        return new Vec3(yaw, pitch - 90.0, 0.0);
    }

    private static Matrix3f normalToMatrix(Vec3 normal, float roll) {
        Vec3 euler = CutModelUtil.getEulerAngles(normal);
        return CutModelUtil.eulerToMat((float)Math.toRadians(euler.f_82479_), (float)Math.toRadians(euler.f_82480_ + 90.0), roll);
    }

    private static Optional<Vec3> getNext(List<Vec3[]> edges, Vec3 first) {
        Iterator<Vec3[]> iter = edges.iterator();
        while (iter.hasNext()) {
            double eps;
            Vec3[] v = iter.next();
            if (CutModelUtil.epsilonEquals(v[0], first, eps = 1.0E-5)) {
                iter.remove();
                return Optional.of(v[1]);
            }
            if (!CutModelUtil.epsilonEquals(v[1], first, eps)) continue;
            iter.remove();
            return Optional.of(v[0]);
        }
        return Optional.empty();
    }

    private static RigidBody.VertexData[] cutAndCapConvex(RigidBody.Triangle[] triangles, float[] plane) {
        RigidBody.VertexData[] result = new RigidBody.VertexData[]{null, null, new RigidBody.VertexData()};
        ArrayList<RigidBody.Triangle> side1 = new ArrayList<RigidBody.Triangle>();
        ArrayList<RigidBody.Triangle> side2 = new ArrayList<RigidBody.Triangle>();
        ArrayList<Vec3[]> clippedEdges = new ArrayList<Vec3[]>();
        for (RigidBody.Triangle triangle : triangles) {
            int[] deColor;
            float[] deUv;
            Vec3 e;
            Vec3 d;
            float interceptAC;
            float interceptAB;
            Vec3 rAC;
            Vec3 rAB;
            RigidBody.Triangle.TexVertex c;
            RigidBody.Triangle.TexVertex b;
            RigidBody.Triangle.TexVertex a;
            boolean p3;
            boolean p1 = triangle.p1.pos.f_82479_ * (double)plane[0] + triangle.p1.pos.f_82480_ * (double)plane[1] + triangle.p1.pos.f_82481_ * (double)plane[2] + (double)plane[3] > 0.0;
            boolean p2 = triangle.p2.pos.f_82479_ * (double)plane[0] + triangle.p2.pos.f_82480_ * (double)plane[1] + triangle.p2.pos.f_82481_ * (double)plane[2] + (double)plane[3] > 0.0;
            boolean bl = p3 = triangle.p3.pos.f_82479_ * (double)plane[0] + triangle.p3.pos.f_82480_ * (double)plane[1] + triangle.p3.pos.f_82481_ * (double)plane[2] + (double)plane[3] > 0.0;
            if (p1 && p2 && p3) {
                side1.add(triangle);
                continue;
            }
            if (!(p1 || p2 || p3)) {
                side2.add(triangle);
                continue;
            }
            if (p1 ^ p2 ^ p3) {
                if (p1) {
                    a = triangle.p1;
                    b = triangle.p2;
                    c = triangle.p3;
                } else if (p2) {
                    a = triangle.p2;
                    b = triangle.p3;
                    c = triangle.p1;
                } else {
                    a = triangle.p3;
                    b = triangle.p1;
                    c = triangle.p2;
                }
                rAB = b.pos.m_82546_(a.pos);
                rAC = c.pos.m_82546_(a.pos);
                interceptAB = (float)CutModelUtil.rayPlaneIntercept(a.pos, rAB, plane);
                interceptAC = (float)CutModelUtil.rayPlaneIntercept(a.pos, rAC, plane);
                d = a.pos.m_82549_(rAB.m_82490_((double)interceptAB));
                e = a.pos.m_82549_(rAC.m_82490_((double)interceptAC));
                deUv = new float[]{a.u + (b.u - a.u) * interceptAB, a.v + (b.v - a.v) * interceptAB, a.u + (c.u - a.u) * interceptAC, a.v + (c.v - a.v) * interceptAC};
                deColor = new int[4];
                deColor[0] = (int)((float)a.color + (float)(b.color - a.color) * interceptAB);
                deColor[1] = (int)((float)a.color + (float)(c.color - a.color) * interceptAC);
                side2.add(new RigidBody.Triangle(d, b.pos, e, new float[]{deUv[0], deUv[1], b.u, b.v, deUv[2], deUv[3]}, new int[]{deColor[0], b.color, deColor[1]}));
                side2.add(new RigidBody.Triangle(b.pos, c.pos, e, new float[]{b.u, b.v, c.u, c.v, deUv[2], deUv[3]}, new int[]{b.color, c.color, deColor[1]}));
                side1.add(new RigidBody.Triangle(a.pos, d, e, new float[]{a.u, a.v, deUv[0], deUv[1], deUv[2], deUv[3]}, new int[]{a.color, deColor[0], deColor[1]}));
                clippedEdges.add(new Vec3[]{d, e});
                continue;
            }
            if (!p1) {
                a = triangle.p1;
                b = triangle.p2;
                c = triangle.p3;
            } else if (!p2) {
                a = triangle.p2;
                b = triangle.p3;
                c = triangle.p1;
            } else {
                a = triangle.p3;
                b = triangle.p1;
                c = triangle.p2;
            }
            rAB = b.pos.m_82546_(a.pos);
            rAC = c.pos.m_82546_(a.pos);
            interceptAB = (float)CutModelUtil.rayPlaneIntercept(a.pos, rAB, plane);
            interceptAC = (float)CutModelUtil.rayPlaneIntercept(a.pos, rAC, plane);
            d = a.pos.m_82549_(rAB.m_82490_((double)interceptAB));
            e = a.pos.m_82549_(rAC.m_82490_((double)interceptAC));
            deUv = new float[]{a.u + (b.u - a.u) * interceptAB, a.v + (b.v - a.v) * interceptAB, a.u + (c.u - a.u) * interceptAC, a.v + (c.v - a.v) * interceptAC};
            deColor = new int[4];
            deColor[0] = (int)((float)a.color + (float)(b.color - a.color) * interceptAB);
            deColor[1] = (int)((float)a.color + (float)(c.color - a.color) * interceptAC);
            side1.add(new RigidBody.Triangle(d, b.pos, e, new float[]{deUv[0], deUv[1], b.u, b.v, deUv[2], deUv[3]}, new int[]{deColor[0], b.color, deColor[1]}));
            side1.add(new RigidBody.Triangle(b.pos, c.pos, e, new float[]{b.u, b.v, c.u, c.v, deUv[2], deUv[3]}, new int[]{b.color, c.color, deColor[1]}));
            side2.add(new RigidBody.Triangle(a.pos, d, e, new float[]{a.u, a.v, deUv[0], deUv[1], deUv[2], deUv[3]}, new int[]{a.color, deColor[0], deColor[1]}));
            clippedEdges.add(new Vec3[]{e, d});
        }
        if (!clippedEdges.isEmpty()) {
            Optional<Vec3> next;
            Matrix3f matrix3f = CutModelUtil.normalToMatrix(new Vec3((double)plane[0], (double)plane[1], (double)plane[2]), 0.0f);
            ArrayList<Vec3> orderedClipVertices = new ArrayList<Vec3>();
            orderedClipVertices.add(((Vec3[])clippedEdges.get(0))[0]);
            while (!clippedEdges.isEmpty() && !(next = CutModelUtil.getNext(clippedEdges, (Vec3)orderedClipVertices.get(orderedClipVertices.size() - 1))).isEmpty()) {
                orderedClipVertices.add(next.get());
            }
            Vector3f uv1 = new Vector3f((float)((Vec3)orderedClipVertices.get((int)0)).f_82479_, (float)((Vec3)orderedClipVertices.get((int)0)).f_82480_, (float)((Vec3)orderedClipVertices.get((int)0)).f_82481_);
            matrix3f.transform(uv1);
            RigidBody.Triangle[] cap = new RigidBody.Triangle[orderedClipVertices.size() - 2];
            for (int i = 0; i < cap.length; ++i) {
                Vector3f uv2 = new Vector3f((float)((Vec3)orderedClipVertices.get((int)(i + 2))).f_82479_, (float)((Vec3)orderedClipVertices.get((int)(i + 2))).f_82480_, (float)((Vec3)orderedClipVertices.get((int)(i + 2))).f_82481_);
                matrix3f.transform(uv2);
                Vector3f uv3 = new Vector3f((float)((Vec3)orderedClipVertices.get((int)(i + 1))).f_82479_, (float)((Vec3)orderedClipVertices.get((int)(i + 1))).f_82480_, (float)((Vec3)orderedClipVertices.get((int)(i + 1))).f_82481_);
                matrix3f.transform(uv3);
                cap[i] = new RigidBody.Triangle((Vec3)orderedClipVertices.get(0), (Vec3)orderedClipVertices.get(i + 2), (Vec3)orderedClipVertices.get(i + 1), new float[]{uv1.x, uv1.y, uv2.x, uv2.y, uv3.x, uv3.y}, new int[]{-1, -1, -1});
                side1.add(new RigidBody.Triangle((Vec3)orderedClipVertices.get(0), (Vec3)orderedClipVertices.get(i + 2), (Vec3)orderedClipVertices.get(i + 1), new float[6], new int[3]));
                side2.add(new RigidBody.Triangle((Vec3)orderedClipVertices.get(0), (Vec3)orderedClipVertices.get(i + 1), (Vec3)orderedClipVertices.get(i + 2), new float[6], new int[3]));
            }
            result[2] = CutModelUtil.compress(cap);
        }
        result[0] = CutModelUtil.compress(side1.toArray(new RigidBody.Triangle[0]));
        result[1] = CutModelUtil.compress(side2.toArray(new RigidBody.Triangle[0]));
        return result;
    }

    private static int[] getTextureDimensions(int textureID) {
        int[] dimensions = new int[2];
        GL11.glBindTexture((int)3553, (int)textureID);
        dimensions[0] = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        dimensions[1] = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        return dimensions;
    }

    private static float[] readTextureData(int textureID) {
        int[] dimensions = CutModelUtil.getTextureDimensions(textureID);
        int width = dimensions[0];
        int height = dimensions[1];
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid texture dimensions.");
        }
        float[] buffer = new float[width * height * 4];
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5126, (float[])buffer);
        return buffer;
    }

    private static float getAlphaValue(float[] buffer, int[] dimensions, int x, int y) {
        int width = dimensions[0];
        int index = (y * width + x) * 4;
        return buffer[index + 3];
    }

    public static void collect(FakeEntityRenderer renderer, Vector3f plane, float distance, float partialTicks, List<RigidBody.CutModelData> top, List<RigidBody.CutModelData> bottom) {
        Minecraft mc = Minecraft.m_91087_();
        VertexCapturer.capture = true;
        mc.m_91385_().m_83970_();
        renderer.render(new PoseStack(), partialTicks);
        mc.m_91385_().m_83947_(false);
        VertexCapturer.capture = false;
        HashMap<RenderType, TextureData> textures = new HashMap<RenderType, TextureData>();
        for (VertexCapturer.Capture capture : VertexCapturer.captured) {
            if (textures.containsKey(capture.type())) continue;
            int previous = RenderSystem.getShaderTexture((int)0);
            capture.type().m_110185_();
            int current = RenderSystem.getShaderTexture((int)0);
            capture.type().m_110188_();
            if (previous == current) continue;
            float[] buffer = CutModelUtil.readTextureData(current);
            int[] dimensions = CutModelUtil.getTextureDimensions(current);
            textures.put(capture.type(), new TextureData(buffer, dimensions));
        }
        for (int i = 0; i < VertexCapturer.captured.size(); ++i) {
            VertexCapturer.Capture capture;
            capture = VertexCapturer.captured.get(i);
            for (RigidBody.Triangle[] triangles : capture.triangles()) {
                if (textures.containsKey(capture.type())) {
                    boolean visible = false;
                    TextureData data = (TextureData)textures.get(capture.type());
                    for (int j = 0; j < triangles.length; j += 2) {
                        RigidBody.Triangle t1 = triangles[j];
                        RigidBody.Triangle t2 = triangles[j + 1];
                        float[] uv = new float[]{t1.p1.u, t1.p1.v, t1.p2.u, t1.p2.v, t1.p3.u, t1.p3.v, t2.p2.u, t2.p2.v};
                        int width = data.dimensions[0];
                        int height = data.dimensions[1];
                        float minX = Float.MAX_VALUE;
                        float minY = Float.MAX_VALUE;
                        float maxX = Float.MIN_VALUE;
                        float maxY = Float.MIN_VALUE;
                        for (int k = 0; k < uv.length; k += 2) {
                            float u = uv[k];
                            float v = uv[k + 1];
                            if (u < minX) {
                                minX = u;
                            }
                            if (u > maxX) {
                                maxX = u;
                            }
                            if (v < minY) {
                                minY = v;
                            }
                            if (!(v > maxY)) continue;
                            maxY = v;
                        }
                        int startX = Math.max(0, Math.round(minX * (float)(width - 1)));
                        int endX = Math.min(width - 1, Math.round(maxX * (float)(width - 1)));
                        int startY = Math.max(0, Math.round(minY * (float)(height - 1)));
                        int endY = Math.min(height - 1, Math.round(maxY * (float)(height - 1)));
                        block5: for (int x = startX; x < endX && !visible; ++x) {
                            for (int y = startY; y < endY; ++y) {
                                if (CutModelUtil.getAlphaValue(data.buffer, data.dimensions, x, y) == 0.0f) continue;
                                visible = true;
                                continue block5;
                            }
                        }
                    }
                    if (!visible) continue;
                }
                RigidBody.VertexData[] data = CutModelUtil.cutAndCapConvex(triangles, new float[]{plane.x, plane.y, plane.z, -distance});
                RigidBody.CutModelData tp = null;
                RigidBody.CutModelData bt = null;
                if (data[0].indices != null && data[0].indices.length > 0) {
                    tp = new RigidBody.CutModelData(capture.type(), data[0], null, false, new ConvexMeshCollider(data[0].indices, data[0].vertices(), 1.0f));
                    top.add(tp);
                }
                if (data[1].indices != null && data[1].indices.length > 0) {
                    bt = new RigidBody.CutModelData(capture.type(), data[1], null, true, new ConvexMeshCollider(data[1].indices, data[1].vertices(), 1.0f));
                    bottom.add(bt);
                }
                if (data[2].indices == null || data[2].indices.length <= 0) continue;
                tp.cap = data[2];
                bt.cap = data[2];
            }
        }
        VertexCapturer.captured.clear();
    }

    private record TextureData(float[] buffer, int[] dimensions) {
    }
}

