/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.visual.visual;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.particle.TravelParticle;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.client.visual.base.IVisual;
import radon.jujutsu_kaisen.util.HelperMethods;

public class BlueFistsVisual
implements IVisual {
    private static final float RADIUS = 1.5f;
    private static final float PARTICLE_SIZE = 0.3f;

    private static Vec3 rotateRoll(Vec3 pos, float roll) {
        float f = Mth.m_14089_((float)roll);
        float f1 = Mth.m_14031_((float)roll);
        double d0 = pos.f_82479_ * (double)f - pos.f_82480_ * (double)f1;
        double d1 = pos.f_82480_ * (double)f + pos.f_82479_ * (double)f1;
        double d2 = pos.f_82481_;
        return new Vec3(d0, d1, d2);
    }

    private static Vec3 transform3rdPerson(Vec3 pos, Vec3 angles, LivingEntity entity, HumanoidArm arm, float partialTicks) {
        return BlueFistsVisual.rotateRoll(pos, (float)angles.f_82481_).m_82496_((float)(-angles.f_82479_)).m_82524_((float)(-angles.f_82480_)).m_82520_((double)(0.0586f * (arm == HumanoidArm.RIGHT ? -6.0f : 6.0f)), (double)(1.3f - (entity.m_6144_() ? 0.3f : 0.0f)), (double)-0.05f).m_82524_(-Mth.m_14179_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_) * ((float)Math.PI / 180)).m_82520_(Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_()));
    }

    @Override
    public boolean isValid(LivingEntity entity, ClientVisualHandler.ClientData data) {
        return data.toggled.contains(JJKAbilities.BLUE_FISTS.get());
    }

    @Override
    public void tick(LivingEntity entity, ClientVisualHandler.ClientData data) {
        LivingEntityRenderer living;
        EntityModel entityModel;
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)entity);
        if (renderer instanceof LivingEntityRenderer && (entityModel = (living = (LivingEntityRenderer)renderer).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoid = (HumanoidModel)entityModel;
            Vec3 right = BlueFistsVisual.transform3rdPerson(new Vec3(0.0, -0.5499999940395355, 0.0), new Vec3((double)humanoid.f_102811_.f_104203_, (double)humanoid.f_102811_.f_104204_, (double)humanoid.f_102811_.f_104205_), entity, HumanoidArm.RIGHT, mc.getPartialTick());
            BlueFistsVisual.spawn(entity.m_9236_(), right);
            Vec3 left = BlueFistsVisual.transform3rdPerson(new Vec3(0.0, -0.5499999940395355, 0.0), new Vec3((double)humanoid.f_102812_.f_104203_, (double)humanoid.f_102812_.f_104204_, (double)humanoid.f_102812_.f_104205_), entity, HumanoidArm.LEFT, mc.getPartialTick());
            BlueFistsVisual.spawn(entity.m_9236_(), left);
        }
    }

    public static void spawn(Level level, Vec3 pos) {
        double z;
        double y;
        double x;
        double zOffset;
        double yOffset;
        double xOffset;
        double phi;
        double theta;
        int i;
        int count = 9;
        for (i = 0; i < count; ++i) {
            theta = HelperMethods.RANDOM.m_188500_() * Math.PI * 2.0;
            phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
            xOffset = 1.5 * Math.sin(phi) * Math.cos(theta);
            yOffset = 1.5 * Math.sin(phi) * Math.sin(theta);
            zOffset = 1.5 * Math.cos(phi);
            x = pos.f_82479_ + xOffset * (double)0.15f;
            y = pos.f_82480_ + yOffset * (double)0.15f;
            z = pos.f_82481_ + zOffset * (double)0.15f;
            level.m_7106_((ParticleOptions)new TravelParticle.TravelParticleOptions(pos.m_252839_(), ParticleColors.DARK_BLUE, 0.3f, 0.2f, true, 20), x, y, z, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < count; ++i) {
            theta = HelperMethods.RANDOM.m_188500_() * Math.PI * 2.0;
            phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
            xOffset = 0.75 * Math.sin(phi) * Math.cos(theta);
            yOffset = 0.75 * Math.sin(phi) * Math.sin(theta);
            zOffset = 0.75 * Math.cos(phi);
            x = pos.f_82479_ + xOffset * (double)0.075f;
            y = pos.f_82480_ + yOffset * (double)0.075f;
            z = pos.f_82481_ + zOffset * (double)0.075f;
            level.m_7106_((ParticleOptions)new TravelParticle.TravelParticleOptions(pos.m_252839_(), ParticleColors.LIGHT_BLUE, 0.15f, 0.2f, true, 20), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

